% Generated by roxygen2 (4.0.0): do not edit by hand
\name{stri_length}
\alias{stri_length}
\title{Count the Number of Characters}
\usage{
stri_length(str)
}
\arguments{
\item{str}{character vector or an object coercible to}
}
\value{
Returns an integer vector of the same length as \code{str}.
}
\description{
This function returns the number of code points
in each string.
}
\details{
Note that the number of code points is
not the same as the `width` of the string when
printed on the screen.

If a given string is in UTF-8 and  has not been properly normalized
(e.g. by \code{\link{stri_trans_nfc}}), the returned counts may sometimes be
misleading. Moreover, if an incorrect UTF-8 byte sequence is detected,
then a warning is generated and the corresponding output element
is set to \code{NA}, see also \code{\link{stri_enc_toutf8}} for a method
to deal with such cases.

Missing values are handled properly,
as opposed to the built-in \code{\link{nchar}} function.
For `byte` encodings we get, as usual, an error.
}
\examples{
\dontshow{if (stri_install_check(silent=TRUE))}
stri_length(LETTERS)

\dontshow{if (stri_install_check(silent=TRUE))}
stri_length(c('abc', '123', '\\u0105\\u0104'))

\dontshow{if (stri_install_check(silent=TRUE))}
stri_length('\\u0105') # length is one, but...

\dontshow{if (stri_install_check(silent=TRUE))}
stri_numbytes('\\u0105') # 2 bytes are used

\dontshow{if (stri_install_check(silent=TRUE))}
stri_length(stri_trans_nfkd('\\u0105')) # ...two code points (!)
}
\seealso{
Other length: \code{\link{stri_isempty}};
  \code{\link{stri_numbytes}}
}

