% Generated by roxygen2 (4.0.0): do not edit by hand
\name{\%<\%}
\alias{\%!==\%}
\alias{\%!=\%}
\alias{\%<=\%}
\alias{\%<\%}
\alias{\%===\%}
\alias{\%==\%}
\alias{\%>=\%}
\alias{\%>\%}
\alias{\%stri!==\%}
\alias{\%stri!=\%}
\alias{\%stri<=\%}
\alias{\%stri<\%}
\alias{\%stri===\%}
\alias{\%stri==\%}
\alias{\%stri>=\%}
\alias{\%stri>\%}
\title{Compare Strings with or without Collation}
\usage{
e1 \%<\% e2

e1 \%<=\% e2

e1 \%>\% e2

e1 \%>=\% e2

e1 \%==\% e2

e1 \%!=\% e2

e1 \%===\% e2

e1 \%!==\% e2

e1 \%stri<\% e2

e1 \%stri<=\% e2

e1 \%stri>\% e2

e1 \%stri>=\% e2

e1 \%stri==\% e2

e1 \%stri!=\% e2

e1 \%stri===\% e2

e1 \%stri!==\% e2
}
\arguments{
\item{e1,e2}{character vectors or objects coercible to character vectors}
}
\value{
All the functions return a logical vector
indicating the result of the element-by-element comparison.
As usual, the elements of shorter vectors are recycled as necessary.
}
\description{
Relational operators for comparing corresponding strings in
two character vectors, with a typical \R look-and-feel.
}
\details{
These functions call \code{\link{stri_cmp_le}} or its
friends, using default collator options.
Thus, they are vectorized over \code{e1} and \code{e2}.

\code{\%stri==\%} tests for canonical equivalence of strings
(see \code{\link{stri_cmp_equiv}}) and is a locale-dependent operation.
On the other hand, \code{\%stri===\%} performs a locale-independent,
code point-based comparison.
}
\examples{
"a" \%stri<\% "b"
c("a", "b", "c") \%stri>=\% "b"
}
\seealso{
Other locale_sensitive: \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_count_coll}};
  \code{\link{stri_detect_coll}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_first_coll}},
  \code{\link{stri_extract_last_coll}},
  \code{\link{stri_extract_last_coll}};
  \code{\link{stri_extract_words}};
  \code{\link{stri_locate_all_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_first_coll}},
  \code{\link{stri_locate_last_coll}},
  \code{\link{stri_locate_last_coll}};
  \code{\link{stri_locate_boundaries}};
  \code{\link{stri_locate_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_replace_all_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_first_coll}},
  \code{\link{stri_replace_last_coll}},
  \code{\link{stri_replace_last_coll}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_coll}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-coll}}
}

