% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{str_trim_anything}
\alias{str_trim_anything}
\title{Trim something other than whitespace}
\usage{
str_trim_anything(string, pattern, side = "both")
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{The pattern to look for.

The default interpretation is a regular expression, as described in
\link[stringi:about_search_regex]{stringi::about_search_regex}.

To match a without regular expression (i.e. as a human would), use
\link[stringr:modifiers]{coll()}. For details see \code{\link[stringr:modifiers]{stringr::regex()}}.}

\item{side}{Which side do you want to trim from? \code{"both"} is the
default, but you can also have just either \code{"left"} or \code{"right"}
(or optionally the shortened \code{"b"}, \code{"l"} and \code{"r"}).}
}
\value{
A string.
}
\description{
The \code{stringi} and \code{stringr} packages let you trim whitespace, but
what if you want to trim something else from either (or both) side(s) of a
string? This function lets you select which pattern to trim and from which
side(s).
}
\examples{
str_trim_anything("..abcd.", ".", "left")
str_trim_anything("..abcd.", coll("."), "left")
str_trim_anything("-ghi--", "-", "both")
str_trim_anything("-ghi--", "-")
str_trim_anything("-ghi--", "-", "right")
str_trim_anything("-ghi--", "--")
str_trim_anything("-ghi--", "i-+")

}
\seealso{
Other removers: 
\code{\link{str_remove_quoted}()},
\code{\link{str_singleize}()}
}
\concept{removers}
