% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-before.R
\name{str_nth_number_before_mth}
\alias{str_nth_number_before_mth}
\alias{str_nth_number_before_first}
\alias{str_nth_number_before_last}
\alias{str_first_number_before_mth}
\alias{str_last_number_before_mth}
\alias{str_first_number_before_first}
\alias{str_first_number_before_last}
\alias{str_last_number_before_first}
\alias{str_last_number_before_last}
\title{Find the \eqn{n}th number before the \eqn{m}th occurrence of a pattern.}
\usage{
str_nth_number_before_mth(string, pattern, n, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_nth_number_before_first(string, pattern, n, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_nth_number_before_last(string, pattern, n, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_first_number_before_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_last_number_before_mth(string, pattern, m, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_first_number_before_first(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_first_number_before_last(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_last_number_before_first(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)

str_last_number_before_last(string, pattern, decimals = FALSE,
  leading_decimals = FALSE, negs = FALSE, leave_as_string = FALSE)
}
\arguments{
\item{string}{A character vector.}

\item{pattern}{A character vector. Pattern(s) specified like the pattern(s)
in the stringr package (e.g. look at \code{\link[stringr:str_locate]{stringr::str_locate()}}). If
this has length >1 its length must be the same as that of \code{string}.}

\item{n, m}{Natural numbers.}

\item{decimals}{Do you want to include the possibility of decimal numbers
(\code{TRUE}) or not (\code{FALSE}, the default).}

\item{leading_decimals}{Do you want to allow a leading decimal point to be
the start of a number?}

\item{negs}{Do you want to allow negative numbers? Note that double negatives
are not handled here (see the examples).}

\item{leave_as_string}{Do you want to return the number as a string (\code{TRUE})
or as numeric (\code{FALSE}, the default)?}
}
\value{
A numeric vector.
}
\description{
Given a string, a pattern and natural numbers \code{n} and \code{m}, find the \code{n}th
number that comes before the \code{m}th occurrence of the pattern.
}
\examples{
string <- c("abc1abc2abc3abc4def5abc6abc7abc8abc9",
            "abc1def2ghi3abc4def5ghi6abc7def8ghi9")
str_nth_number_before_mth(string, "def", 1, 1)
str_nth_number_before_mth(string, "abc", 2, 3)
str_nth_number_before_first(string, "def", 2)
str_nth_number_before_last(string, "def", -1)
str_first_number_before_mth(string, "abc", 2)
str_last_number_before_mth(string, "def", 1)
str_first_number_before_first(string, "def")
str_first_number_before_last(string, "def")
str_last_number_before_first(string, "def")
str_last_number_before_last(string, "def")
}
