% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_classification.R
\name{score_classification}
\alias{score_classification}
\title{Score Function for Binary Classification}
\usage{
score_classification(
  observed,
  predicted,
  metrics = c("Accuracy", "AUC", "Recall", "Prec.", "F1", "MCC", "Kappa")
)
}
\arguments{
\item{observed}{A vector of the observed results.}

\item{predicted}{A data.frame or vector object that is the same number of
rows or length as the length of observed values.}

\item{metrics}{A character vector of the metrics to be fitted. This is
defaulted to be the metrics from `PyCaret`.}
}
\value{
A vector or data.frame of the methods and metrics.
}
\description{
This function takes the observed and predicted values and computes metrics
 that are found in `PyCaret` such as: `Accuracy`, `AUC`, `Recall`, `Prec.`,
 `F1`, `MCC`, and `Kappa`.
}
