% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_ecxsys.R
\name{predict_ecxsys}
\alias{predict_ecxsys}
\title{Predict survival and stress}
\usage{
predict_ecxsys(model, concentration)
}
\arguments{
\item{model}{An ECx-SyS model as returned by \code{\link{ecxsys}}.}

\item{concentration}{A numeric vector of concentrations.}
}
\value{
A data frame (of class "ecxsys_predicted") with the following
  columns:
  \describe{
    \item{concentration}{The supplied concentrations.}
    \item{survival_tox_LL5}{The survival predicted by the five-parameter
    log-logistic model derived from the observations under toxicant stress
    but without environmental stress.}
    \item{survival_tox}{Modeled survival resulting from toxicant stress.}
    \item{survival_tox_sys}{Modeled survival resulting from toxicant
    and system stress.}
    \item{stress_tox}{The toxicant stress.}
    \item{sys_tox}{System stress under toxicant stress conditions
    without environmental stress.}
    \item{stress_tox_sys}{The sum of \code{stress_tox} and
    \code{sys_tox}.}
    \item{survival_tox_env_LL5}{The survival predicted by the five-parameter
    log-logistic model derived from the observations under toxicant stress
    with environmental stress.}
    \item{survival_tox_env}{Modeled survival resulting from toxicant and
    environmental stress.}
    \item{survival_tox_env_sys}{Modeled survival resulting from toxicant,
    environmental and system stress.}
    \item{stress_env}{Environmental stress.}
    \item{stress_tox_env}{The sum of toxicant and environmental stress.}
    \item{sys_tox_env}{System stress under toxicant and
    environmental stress conditions.}
    \item{stress_tox_env_sys}{The sum of \code{stress_tox_env} and
    \code{sys_tox_env}.}
  }
}
\description{
Calculate the survivals and stresses of an ECx-SyS model at arbitrary
concentrations.
}
\examples{
model <- ecxsys(
    concentration = c(0, 0.05, 0.5, 5, 30),
    hormesis_concentration = 0.5,
    survival_tox_observed = c(90, 81, 92, 28, 0),
    survival_tox_env_observed = c(29, 27, 33, 5, 0)
)
p <- predict_ecxsys(model, c(0.001, 0.01, 0.1, 1, 10))

}
