/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.visualization;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import moa.gui.visualization.ClusterPanel;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.RunVisualizer;
import moa.gui.visualization.StreamPanel;

public class PointPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    static final int POINTSIZE = 4;
    DataPoint point;
    protected int x_dim = 0;
    protected int y_dim = 1;
    protected Color col;
    protected Color default_color = Color.BLACK;
    protected int panel_size;
    protected int window_size;
    protected boolean highligted = false;
    protected double decayRate;
    protected double decayThreshold;
    protected int type;
    protected final int TYPE_PLAIN = 0;
    protected final int TYPE_CLUSTERED = 1;
    protected StreamPanel sp;

    public PointPanel(DataPoint point, StreamPanel streamPanel, double decayRate, double decayThreshold) {
        this.point = point;
        this.panel_size = 4;
        this.decayRate = decayRate;
        this.decayThreshold = decayThreshold;
        this.col = this.default_color;
        this.sp = streamPanel;
        this.type = 0;
        this.setVisible(true);
        this.setOpaque(false);
        this.setSize(new Dimension(1, 1));
        this.setLocation(0, 0);
        this.initComponents();
    }

    public PointPanel(DataPoint point, StreamPanel streamPanel, Color color) {
        this.point = point;
        this.panel_size = 4;
        this.decayRate = 0.0;
        this.decayThreshold = 0.0;
        this.col = color;
        this.sp = streamPanel;
        this.type = 1;
        this.setVisible(true);
        this.setOpaque(false);
        this.setSize(new Dimension(1, 1));
        this.setLocation(0, 0);
        this.initComponents();
    }

    public void updateLocation() {
        this.window_size = Math.min(this.sp.getWidth(), this.sp.getHeight());
        this.x_dim = this.sp.getActiveXDim();
        this.y_dim = this.sp.getActiveYDim();
        this.setSize(new Dimension(this.panel_size + 1, this.panel_size + 1));
        this.setLocation((int)(this.point.value(this.x_dim) * (double)this.window_size - (double)(this.panel_size / 2)), (int)(this.point.value(this.y_dim) * (double)this.window_size - (double)(this.panel_size / 2)));
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 296, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 266, Short.MAX_VALUE));
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.type == 0) {
            this.point.updateWeight(RunVisualizer.getCurrentTimestamp(), this.decayRate);
            if (this.point.weight() < this.decayThreshold) {
                this.getParent().remove(this);
                return;
            }
        }
        Color color = this.getColor();
        this.panel_size = 4;
        this.updateLocation();
        if (this.type == 0) {
            g.setColor(color);
            if (this.point.isNoise()) {
                g.setFont(g.getFont().deriveFont(9.0f));
                g.drawChars(new char[]{'x'}, 0, 1, 0, this.panel_size);
            } else {
                g.drawOval(0, 0, this.panel_size, this.panel_size);
                g.setColor(color);
                g.fillOval(0, 0, this.panel_size, this.panel_size);
            }
        } else if (this.type == 1) {
            g.setColor(color);
            g.drawOval(0, 0, this.panel_size, this.panel_size);
        }
        this.setToolTipText(this.point.getInfo(this.x_dim, this.y_dim));
    }

    private Color getErrorColor() {
        String cmdvalue = this.point.getMeasureValue("CMM");
        Color color = null;
        if (!cmdvalue.equals("")) {
            double err = Double.parseDouble(cmdvalue);
            if (err > 1.0E-5) {
                if (err > 0.7) {
                    err = 1.0;
                }
                int alpha = (int)(100.0 + 155.0 * err);
                color = new Color(255, 0, 0, alpha);
            }
            if (err == 1.0E-5) {
                color = new Color(255, 0, 0, 100);
            }
        }
        return color;
    }

    private Color getColor() {
        Color color = null;
        if (this.type == 0) {
            ClusterPanel cp = this.sp.getHighlightedClusterPanel();
            if (cp != null && (double)cp.getClusterLabel() == this.point.classValue()) {
                color = Color.BLUE;
            }
            if (color == null) {
                int alpha = (int)(this.point.weight() * 200.0 + 55.0);
                float numCl = 10.0f;
                Color c = this.point.isNoise() ? Color.GRAY : PointPanel.getPointColorbyClass(this.point, numCl);
                color = new Color(c.getRed(), c.getGreen(), c.getBlue(), alpha);
            }
        } else if (this.type == 1) {
            color = this.col;
        }
        return color;
    }

    public static Color getPointColorbyClass(DataPoint point, float numClasses) {
        int classValue = (int)point.classValue();
        Color c = classValue != point.noiseLabel ? new Color(Color.HSBtoRGB((float)(classValue + 1) / numClasses, 1.0f, 1.0f)) : Color.GRAY;
        return c;
    }

    public void highlight(boolean enabled) {
        this.highligted = enabled;
        this.repaint();
    }

    public String getObjectInfo() {
        return this.point.getInfo(this.x_dim, this.y_dim);
    }

    @Override
    public String getToolTipText() {
        return super.getToolTipText();
    }

    public String getSVGString(int width) {
        StringBuffer out = new StringBuffer();
        int x = (int)(this.point.value(this.x_dim) * (double)this.window_size);
        int y = (int)(this.point.value(this.y_dim) * (double)this.window_size);
        int radius = this.panel_size / 2;
        Color c = this.getColor();
        String color = "rgb(" + c.getRed() + "," + c.getGreen() + "," + c.getBlue() + ")";
        double trans = (double)c.getAlpha() / 255.0;
        out.append("<circle ");
        out.append("cx='" + x + "' cy='" + y + "' r='" + radius + "'");
        out.append(" stroke='" + color + "' stroke-width='0' fill='" + color + "' fill-opacity='" + trans + "' stroke-opacity='" + trans + "'/>");
        out.append("\n");
        return out.toString();
    }

    public void drawOnCanvas(Graphics2D imageGraphics) {
        Point location = this.getLocation();
        if (this.type == 0) {
            imageGraphics.drawOval(location.x, location.y, this.panel_size, this.panel_size);
            imageGraphics.fillOval(location.x, location.y, this.panel_size, this.panel_size);
        } else if (this.type == 1) {
            imageGraphics.drawOval(location.x, location.y, this.panel_size, this.panel_size);
        }
    }
}

