/*
 * Decompiled with CFR 0.152.
 */
package moa.gui.outliertab;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import moa.clusterers.outliers.MyBaseOutlierDetector;
import moa.evaluation.MeasureCollection;
import moa.gui.FileExtensionFilter;
import moa.gui.TextViewerPanel;
import moa.gui.outliertab.OutlierAlgoPanel;
import moa.gui.outliertab.OutlierEvalPanel;
import moa.gui.outliertab.OutlierTabPanel;
import moa.streams.clustering.ClusteringStream;
import nz.ac.waikato.cms.gui.core.BaseFileChooser;

public class OutlierSetupTab
extends JPanel {
    private OutlierTabPanel outlierTab;
    private String lastfile;
    private JButton buttonExport;
    private JButton buttonExportSettings;
    private JButton buttonImportSettings;
    private JButton buttonStart;
    private JButton buttonStop;
    private JButton buttonWeka;
    private OutlierAlgoPanel outlierAlgoPanel0;
    private OutlierEvalPanel outlierEvalPanel1;
    private TextViewerPanel logPanel;

    public OutlierSetupTab() {
        this.initComponents();
        this.outlierAlgoPanel0.renderAlgoPanel();
    }

    public MyBaseOutlierDetector getOutlierer0() {
        return this.outlierAlgoPanel0.getClusterer0();
    }

    public MyBaseOutlierDetector getOutlierer1() {
        return this.outlierAlgoPanel0.getClusterer1();
    }

    public ClusteringStream getStream0() {
        return this.outlierAlgoPanel0.getStream();
    }

    public MeasureCollection[] getMeasures() {
        return this.outlierEvalPanel1.getSelectedMeasures();
    }

    public TextViewerPanel getLogPanel() {
        return this.logPanel;
    }

    public void addButtonActionListener(ActionListener l) {
        this.buttonWeka.addActionListener(l);
        this.buttonWeka.setActionCommand("weka export");
        this.buttonExport.addActionListener(l);
        this.buttonExport.setActionCommand("csv export");
    }

    private void initComponents() {
        this.outlierAlgoPanel0 = new OutlierAlgoPanel();
        this.outlierEvalPanel1 = new OutlierEvalPanel();
        this.buttonStart = new JButton();
        this.buttonStop = new JButton();
        this.buttonExport = new JButton();
        this.buttonWeka = new JButton();
        this.buttonImportSettings = new JButton();
        this.buttonExportSettings = new JButton();
        this.logPanel = new TextViewerPanel();
        this.setLayout(new GridBagLayout());
        this.outlierAlgoPanel0.setMinimumSize(new Dimension(335, 150));
        this.outlierAlgoPanel0.setPanelTitle("Outlier Detection Algorithm Setup");
        this.outlierAlgoPanel0.setPreferredSize(new Dimension(500, 150));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.outlierAlgoPanel0, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        int iBtnHeight = 27;
        this.buttonStart.setText("Start");
        this.buttonStart.setMinimumSize(new Dimension(80, iBtnHeight));
        this.buttonStart.setPreferredSize(new Dimension(80, iBtnHeight));
        this.buttonStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierSetupTab.this.buttonStartActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonStart, gridBagConstraints);
        this.buttonStop.setText("Stop");
        this.buttonStop.setMinimumSize(new Dimension(80, iBtnHeight));
        this.buttonStop.setPreferredSize(new Dimension(80, iBtnHeight));
        this.buttonStop.setEnabled(false);
        this.buttonStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierSetupTab.this.buttonStopActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonStop, gridBagConstraints);
        this.buttonExport.setText("Export CSV");
        this.buttonExport.setMinimumSize(new Dimension(120, iBtnHeight));
        this.buttonExport.setPreferredSize(new Dimension(120, iBtnHeight));
        this.buttonExport.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 6;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonExport, gridBagConstraints);
        this.buttonWeka.setText("Weka Explorer");
        this.buttonWeka.setMinimumSize(new Dimension(120, iBtnHeight));
        this.buttonWeka.setPreferredSize(new Dimension(120, iBtnHeight));
        this.buttonWeka.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonWeka, gridBagConstraints);
        this.buttonImportSettings.setText("Import");
        this.buttonImportSettings.setMinimumSize(new Dimension(80, iBtnHeight));
        this.buttonImportSettings.setPreferredSize(new Dimension(80, iBtnHeight));
        this.buttonImportSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierSetupTab.this.buttonImportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 75, 4, 4);
        this.add((Component)this.buttonImportSettings, gridBagConstraints);
        this.buttonExportSettings.setText("Export");
        this.buttonExportSettings.setMinimumSize(new Dimension(80, iBtnHeight));
        this.buttonExportSettings.setPreferredSize(new Dimension(80, iBtnHeight));
        this.buttonExportSettings.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OutlierSetupTab.this.buttonExportSettingsActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.buttonExportSettings, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 7;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.logPanel, gridBagConstraints);
    }

    private void buttonImportSettingsActionPerformed(ActionEvent evt) {
        BaseFileChooser fileChooser = new BaseFileChooser();
        fileChooser.setAcceptAllFileFilterUsed(true);
        fileChooser.addChoosableFileFilter((FileFilter)new FileExtensionFilter("txt"));
        if (this.lastfile != null) {
            fileChooser.setSelectedFile(new File(this.lastfile));
        }
        if (fileChooser.showOpenDialog((Component)this.buttonImportSettings) == 0) {
            this.lastfile = fileChooser.getSelectedFile().getPath();
            this.loadOptionsFromFile(fileChooser.getSelectedFile().getPath());
        }
    }

    private void buttonExportSettingsActionPerformed(ActionEvent evt) {
        StringBuffer sb = new StringBuffer();
        sb.append(this.outlierAlgoPanel0.getStreamValueAsCLIString() + "\n");
        sb.append(this.outlierAlgoPanel0.getAlgorithm0ValueAsCLIString() + "\n");
        System.out.println(sb);
        this.logPanel.addText(sb.toString());
    }

    private void buttonStartActionPerformed(ActionEvent evt) {
        this.toggle(true);
    }

    private void buttonStopActionPerformed(ActionEvent evt) {
        this.stop(true);
    }

    private void loadOptionsFromFile(String filepath) {
        try {
            BufferedReader in = new BufferedReader(new FileReader(filepath));
            String stream0 = in.readLine();
            this.outlierAlgoPanel0.setStreamValueAsCLIString(stream0);
            String algo0 = in.readLine();
            this.outlierAlgoPanel0.setAlgorithm0ValueAsCLIString(algo0);
            System.out.println("Loading settings from " + filepath);
            this.logPanel.addText("Loading settings from " + filepath);
        }
        catch (Exception e) {
            System.out.println("Bad option file:" + e.getMessage());
        }
    }

    void setOutlierTab(OutlierTabPanel outlierTab) {
        this.outlierTab = outlierTab;
    }

    public void toggleRunMode() {
        this.toggle(false);
    }

    public void stopRun() {
        this.stop(false);
    }

    private void toggle(boolean internal) {
        this.setStateConfigButtons(false);
        if (this.buttonStart.getText().equals("Pause")) {
            this.buttonStart.setText("Resume");
            this.buttonWeka.setEnabled(true);
            this.buttonExport.setEnabled(true);
        } else {
            this.buttonStart.setText("Pause");
            this.buttonWeka.setEnabled(false);
            this.buttonExport.setEnabled(false);
        }
        if (internal) {
            this.outlierTab.toggle();
        }
    }

    private void stop(boolean internal) {
        this.buttonStart.setEnabled(true);
        this.buttonStart.setText("Start");
        this.buttonStop.setEnabled(false);
        this.buttonWeka.setEnabled(false);
        this.buttonExport.setEnabled(false);
        this.setStateConfigButtons(true);
        if (internal) {
            this.outlierTab.stop();
        }
    }

    private void setStateConfigButtons(boolean state) {
        this.buttonStop.setEnabled(!state);
        this.buttonExportSettings.setEnabled(state);
        this.buttonImportSettings.setEnabled(state);
    }
}

