/*
 * Decompiled with CFR 0.152.
 */
package moa.cluster;

import java.util.ArrayList;

public class Miniball {
    int d;
    ArrayList L;
    Miniball_b B;
    int support_end = 0;

    public Miniball(int dim) {
        this.d = dim;
        this.L = new ArrayList();
        this.B = new Miniball_b();
    }

    public void clear() {
        this.L.clear();
    }

    public void check_in(double[] p) {
        if (p != null) {
            this.L.add(p);
        } else {
            System.out.println("Miniball.check_in WARNING: Skipping null point");
        }
    }

    public void build() {
        this.B.reset();
        this.support_end = 0;
        this.pivot_mb(this.points_end());
    }

    void mtf_mb(int i) {
        int pj = 0;
        this.support_end = this.points_begin();
        if (this.B.size() == this.d + 1) {
            return;
        }
        int k = this.points_begin();
        while (k != i) {
            ++pj;
            int n = k++;
            int j = n;
            double[] sp = (double[])this.L.get(j);
            if (!(this.B.excess(sp) > 0.0) || !this.B.push(sp)) continue;
            this.mtf_mb(j);
            this.B.pop();
            this.move_to_front(j);
        }
    }

    void move_to_front(int j) {
        if (this.support_end <= j) {
            ++this.support_end;
        }
        double[] sp = (double[])this.L.get(j);
        this.L.remove(j);
        this.L.add(0, sp);
    }

    void pivot_mb(int i) {
        int t = 1;
        this.mtf_mb(t);
        double max_e = 0.0;
        double old_sqr_r = -1.0;
        pvt pivot = new pvt();
        do {
            if (!((max_e = this.max_excess(t, i, pivot)) > 0.0)) continue;
            t = this.support_end;
            if (t == pivot.getVal()) {
                ++t;
            }
            old_sqr_r = this.B.squared_radius();
            double[] sp = (double[])this.L.get(pivot.getVal());
            this.B.push(sp);
            this.mtf_mb(this.support_end);
            this.B.pop();
            this.move_to_front(pivot.getVal());
        } while (max_e > 0.0 && this.B.squared_radius() > old_sqr_r);
    }

    double max_excess(int t, int i, pvt pivot) {
        double[] c = this.B.getCenter();
        double sqr_r = this.B.squared_radius();
        double max_e = 0.0;
        for (int k = t; k != i; ++k) {
            double[] p = (double[])this.L.get(k);
            double e = -sqr_r;
            for (int j = 0; j < this.d; ++j) {
                e += this.mb_sqr(p[j] - c[j]);
            }
            if (!(e > max_e)) continue;
            max_e = e;
            pivot.setVal(k);
        }
        return max_e;
    }

    public double[] center() {
        return this.B.getCenter();
    }

    public double squared_radius() {
        return this.B.squared_radius();
    }

    public double radius() {
        return 1.00001 * Math.sqrt(this.B.squared_radius());
    }

    public int nr_points() {
        return this.L.size();
    }

    int points_begin() {
        return 0;
    }

    int points_end() {
        return this.L.size();
    }

    public int nr_support_points() {
        return this.B.support_size();
    }

    int support_points_begin() {
        return 0;
    }

    int support_points_end() {
        return this.support_end;
    }

    double accuracy(double slack) {
        double e;
        double[] sp;
        double max_e = 0.0;
        int n_supp = 0;
        int i = this.points_begin();
        while (i != this.support_end) {
            double d;
            sp = (double[])this.L.get(i);
            e = Math.abs(this.B.excess(sp));
            if (d > max_e) {
                max_e = e;
            }
            ++i;
            ++n_supp;
        }
        if (n_supp == this.nr_support_points()) {
            System.out.println("Miniball.accuracy WARNING: STRANGE PROBLEM HERE!");
        }
        for (i = this.support_end; i != this.points_end(); ++i) {
            double d;
            sp = (double[])this.L.get(i);
            e = this.B.excess(sp);
            if (!(d > max_e)) continue;
            max_e = e;
        }
        slack = this.B.slack();
        return max_e / this.squared_radius();
    }

    boolean is_valid(double tolerance) {
        double slack = 0.0;
        return this.accuracy(slack) < tolerance && slack == 0.0;
    }

    double mb_sqr(double r) {
        return r * r;
    }

    class Miniball_b {
        int m;
        int s;
        double[] q0;
        double[] z;
        double[] f;
        double[][] v;
        double[][] a;
        double[][] c;
        double[] sqr_r;
        double[] current_c;
        double current_sqr_r;

        Miniball_b() {
            this.q0 = new double[Miniball.this.d];
            this.z = new double[Miniball.this.d + 1];
            this.f = new double[Miniball.this.d + 1];
            this.v = new double[Miniball.this.d + 1][Miniball.this.d];
            this.a = new double[Miniball.this.d + 1][Miniball.this.d];
            this.c = new double[Miniball.this.d + 1][Miniball.this.d];
            this.sqr_r = new double[Miniball.this.d + 1];
            this.current_c = new double[Miniball.this.d];
        }

        double[] getCenter() {
            return this.current_c;
        }

        double squared_radius() {
            return this.current_sqr_r;
        }

        int size() {
            return this.m;
        }

        int support_size() {
            return this.s;
        }

        double excess(double[] p) {
            double e = -this.current_sqr_r;
            for (int k = 0; k < Miniball.this.d; ++k) {
                e += Miniball.this.mb_sqr(p[k] - this.current_c[k]);
            }
            return e;
        }

        void reset() {
            this.m = 0;
            this.s = 0;
            for (int j = 0; j < Miniball.this.d; ++j) {
                this.c[0][j] = 0.0;
            }
            this.current_c = this.c[0];
            this.current_sqr_r = -1.0;
        }

        void pop() {
            --this.m;
        }

        boolean push(double[] p) {
            double eps = 1.0E-32;
            if (this.m == 0) {
                int i;
                for (i = 0; i < Miniball.this.d; ++i) {
                    this.q0[i] = p[i];
                }
                for (i = 0; i < Miniball.this.d; ++i) {
                    this.c[0][i] = this.q0[i];
                }
                this.sqr_r[0] = 0.0;
            } else {
                int j;
                int i;
                for (i = 0; i < Miniball.this.d; ++i) {
                    this.v[this.m][i] = p[i] - this.q0[i];
                }
                for (i = 1; i < this.m; ++i) {
                    this.a[this.m][i] = 0.0;
                    for (j = 0; j < Miniball.this.d; ++j) {
                        double[] dArray = this.a[this.m];
                        int n = i;
                        dArray[n] = dArray[n] + this.v[i][j] * this.v[this.m][j];
                    }
                    double[] dArray = this.a[this.m];
                    int n = i;
                    dArray[n] = dArray[n] * (2.0 / this.z[i]);
                }
                for (i = 1; i < this.m; ++i) {
                    for (j = 0; j < Miniball.this.d; ++j) {
                        double[] dArray = this.v[this.m];
                        int n = j;
                        dArray[n] = dArray[n] - this.a[this.m][i] * this.v[i][j];
                    }
                }
                this.z[this.m] = 0.0;
                for (j = 0; j < Miniball.this.d; ++j) {
                    int n = this.m;
                    this.z[n] = this.z[n] + Miniball.this.mb_sqr(this.v[this.m][j]);
                }
                int n = this.m;
                this.z[n] = this.z[n] * 2.0;
                if (this.z[this.m] < eps * this.current_sqr_r) {
                    return false;
                }
                double e = -this.sqr_r[this.m - 1];
                for (i = 0; i < Miniball.this.d; ++i) {
                    e += Miniball.this.mb_sqr(p[i] - this.c[this.m - 1][i]);
                }
                this.f[this.m] = e / this.z[this.m];
                for (i = 0; i < Miniball.this.d; ++i) {
                    this.c[this.m][i] = this.c[this.m - 1][i] + this.f[this.m] * this.v[this.m][i];
                }
                this.sqr_r[this.m] = this.sqr_r[this.m - 1] + e * this.f[this.m] / 2.0;
            }
            this.current_c = this.c[this.m];
            this.current_sqr_r = this.sqr_r[this.m];
            this.s = ++this.m;
            return true;
        }

        double slack() {
            double min_l = 0.0;
            double[] l = new double[Miniball.this.d + 1];
            l[0] = 1.0;
            for (int i = this.s - 1; i > 0; --i) {
                l[i] = this.f[i];
                for (int k = this.s - 1; k > i; --k) {
                    int n = i;
                    l[n] = l[n] - this.a[k][i] * l[k];
                }
                if (l[i] < min_l) {
                    min_l = l[i];
                }
                l[0] = l[0] - l[i];
            }
            if (l[0] < min_l) {
                min_l = l[0];
            }
            return min_l < 0.0 ? -min_l : 0.0;
        }
    }

    class pvt {
        int val = 0;

        pvt() {
        }

        void setVal(int i) {
            this.val = i;
        }

        int getVal() {
            return this.val;
        }
    }
}

