/*
 * Decompiled with CFR 0.152.
 */
package moa.gui;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import moa.cluster.Clustering;
import moa.clusterers.AbstractClusterer;
import moa.clusterers.ClusterGenerator;
import moa.clusterers.KMeans;
import moa.clusterers.clustream.WithKmeans;
import moa.evaluation.EntropyCollection;
import moa.evaluation.F1;
import moa.evaluation.General;
import moa.evaluation.MeasureCollection;
import moa.evaluation.SSQ;
import moa.evaluation.SilhouetteCoefficient;
import moa.evaluation.StatisticalCollection;
import moa.gui.visualization.DataPoint;
import moa.gui.visualization.RunVisualizer;
import moa.streams.clustering.ClusterEvent;
import moa.streams.clustering.ClusterEventListener;
import moa.streams.clustering.ClusteringStream;
import moa.streams.clustering.RandomRBFGeneratorEvents;
import weka.core.DenseInstance;
import weka.core.Instance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BatchCmd
implements ClusterEventListener {
    private ArrayList<ClusterEvent> clusterEvents;
    private AbstractClusterer clusterer;
    private ClusteringStream stream;
    private MeasureCollection[] measures;
    private int totalInstances;
    public boolean useMicroGT = false;

    public BatchCmd(AbstractClusterer clusterer, ClusteringStream stream, MeasureCollection[] measures, int totalInstances) {
        this.clusterer = clusterer;
        this.stream = stream;
        this.totalInstances = totalInstances;
        this.measures = measures;
        if (stream instanceof RandomRBFGeneratorEvents) {
            ((RandomRBFGeneratorEvents)stream).addClusterChangeListener(this);
            this.clusterEvents = new ArrayList();
        } else {
            this.clusterEvents = null;
        }
        stream.prepareForUse();
        clusterer.prepareForUse();
    }

    private ArrayList<ClusterEvent> getEventList() {
        return this.clusterEvents;
    }

    private static ArrayList<Class> getMeasureSelection(int selection) {
        ArrayList<Class> mclasses = new ArrayList<Class>();
        mclasses.add(EntropyCollection.class);
        mclasses.add(F1.class);
        mclasses.add(General.class);
        mclasses.add(SSQ.class);
        mclasses.add(SilhouetteCoefficient.class);
        mclasses.add(StatisticalCollection.class);
        return mclasses;
    }

    public static void main(String[] args) {
        RandomRBFGeneratorEvents stream = new RandomRBFGeneratorEvents();
        WithKmeans clusterer = new WithKmeans();
        int measureCollectionType = 0;
        int amountInstances = 20000;
        String testfile = "d:\\data\\test.csv";
        BatchCmd.runBatch(stream, clusterer, measureCollectionType, amountInstances, testfile);
    }

    public static void runBatch(ClusteringStream stream, AbstractClusterer clusterer, int measureCollectionType, int amountInstances, String outputFile) {
        MeasureCollection[] measures = BatchCmd.getMeasures(BatchCmd.getMeasureSelection(measureCollectionType));
        BatchCmd batch = new BatchCmd(clusterer, stream, measures, amountInstances);
        batch.run();
        ArrayList<ClusterEvent> clusterEvents = batch.getEventList();
        int horizon = stream.decayHorizonOption.getValue();
        BatchCmd.exportCSV(outputFile, clusterEvents, measures, horizon);
    }

    public void run() {
        ArrayList<DataPoint> pointBuffer0 = new ArrayList<DataPoint>();
        int m_timestamp = 0;
        int decayHorizon = this.stream.getDecayHorizon();
        double decay_threshold = this.stream.getDecayThreshold();
        double decay_rate = -1.0 * Math.log(decay_threshold) / (double)decayHorizon;
        int counter = decayHorizon;
        while (m_timestamp < this.totalInstances && this.stream.hasMoreInstances()) {
            --counter;
            Instance next = this.stream.nextInstance();
            DataPoint point0 = new DataPoint(next, ++m_timestamp);
            pointBuffer0.add(point0);
            DenseInstance traininst0 = new DenseInstance(point0);
            if (this.clusterer instanceof ClusterGenerator) {
                traininst0.setDataset(point0.dataset());
            } else {
                traininst0.deleteAttributeAt(point0.classIndex());
            }
            this.clusterer.trainOnInstanceImpl(traininst0);
            if (counter > 0) continue;
            for (DataPoint p : pointBuffer0) {
                p.updateWeight(m_timestamp, decay_rate);
            }
            Clustering clustering0 = null;
            Clustering gtClustering0 = new Clustering(pointBuffer0);
            if (this.useMicroGT && this.stream instanceof RandomRBFGeneratorEvents) {
                gtClustering0 = ((RandomRBFGeneratorEvents)this.stream).getMicroClustering();
            }
            clustering0 = this.clusterer.getClusteringResult();
            if (this.clusterer.implementsMicroClusterer()) {
                if (this.clusterer instanceof ClusterGenerator && this.stream instanceof RandomRBFGeneratorEvents) {
                    ((ClusterGenerator)this.clusterer).setSourceClustering(((RandomRBFGeneratorEvents)this.stream).getMicroClustering());
                }
                Clustering microC = this.clusterer.getMicroClusteringResult();
                if (this.clusterer.evaluateMicroClusteringOption.isSet()) {
                    clustering0 = microC;
                } else if (clustering0 == null && microC != null) {
                    clustering0 = KMeans.gaussianMeans(gtClustering0, microC);
                }
            }
            for (int i = 0; i < this.measures.length; ++i) {
                try {
                    this.measures[i].evaluateClusteringPerformance(clustering0, gtClustering0, pointBuffer0);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            pointBuffer0.clear();
            counter = decayHorizon;
        }
    }

    private static MeasureCollection[] getMeasures(ArrayList<Class> measure_classes) {
        MeasureCollection[] measures = new MeasureCollection[measure_classes.size()];
        for (int i = 0; i < measure_classes.size(); ++i) {
            try {
                MeasureCollection m;
                measures[i] = m = (MeasureCollection)measure_classes.get(i).newInstance();
                continue;
            }
            catch (Exception ex) {
                Logger.getLogger("Couldn't create Instance for " + measure_classes.get(i).getName());
                ex.printStackTrace();
            }
        }
        return measures;
    }

    @Override
    public void changeCluster(ClusterEvent e) {
        if (this.clusterEvents != null) {
            this.clusterEvents.add(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportCSV(String filepath, ArrayList<ClusterEvent> clusterEvents, MeasureCollection[] measures, int horizon) {
        PrintWriter out = null;
        try {
            if (!filepath.endsWith(".csv")) {
                filepath = filepath + ".csv";
            }
            out = new PrintWriter(new BufferedWriter(new FileWriter(filepath)));
            String delimiter = ";";
            int numValues = 0;
            out.write("Nr" + delimiter);
            out.write("Event" + delimiter);
            for (int m = 0; m < 1; ++m) {
                for (int i = 0; i < measures.length; ++i) {
                    for (int j = 0; j < measures[i].getNumMeasures(); ++j) {
                        if (!measures[i].isEnabled(j)) continue;
                        out.write(measures[i].getName(j) + delimiter);
                        numValues = measures[i].getNumberOfValues(j);
                    }
                }
            }
            out.write("\n");
            Iterator<ClusterEvent> eventIt = null;
            ClusterEvent event = null;
            if (clusterEvents != null && clusterEvents.size() > 0) {
                eventIt = clusterEvents.iterator();
                event = eventIt.next();
            }
            for (int v = 0; v < numValues; ++v) {
                out.write(v + delimiter);
                if (event != null && event.getTimestamp() <= (long)horizon) {
                    out.write(event.getType() + delimiter);
                    event = eventIt != null && eventIt.hasNext() ? eventIt.next() : null;
                } else {
                    out.write(delimiter);
                }
                for (int m = 0; m < 1; ++m) {
                    for (int i = 0; i < measures.length; ++i) {
                        for (int j = 0; j < measures[i].getNumMeasures(); ++j) {
                            if (!measures[i].isEnabled(j)) continue;
                            out.write(measures[i].getValue(j, v) + delimiter);
                        }
                    }
                }
                out.write("\n");
            }
            out.close();
        }
        catch (IOException ex) {
            Logger.getLogger(RunVisualizer.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            out.close();
        }
    }
}

