% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save.R
\name{read_saveDSC}
\alias{read_saveDSC}
\alias{saveDSC}
\alias{readDSC}
\title{Save and Read DSC Objects}
\usage{
saveDSC(object, file, ...)

readDSC(file)
}
\arguments{
\item{object}{a DSC object.}

\item{file}{filename.}

\item{...}{further arguments.}
}
\description{
Save and Read DSC objects safely (serializes the underlying data structure).
This also works for \pkg{streamMOA} DSC objects.
}
\examples{

stream <- DSD_Gaussians(k = 3, noise = 0.05)

# create clusterer with r = 0.05
dbstream1 <- DSC_DBSTREAM(r = .05)
update(dbstream1, stream, 1000)
dbstream1

saveDSC(dbstream1, file="dbstream.Rds")

dbstream2 <- readDSC("dbstream.Rds")
dbstream2

## cleanup
unlink("dbstream.Rds")
}
\seealso{
\code{\link{saveRDS}} and \code{\link{readRDS}}.

Other DSC: 
\code{\link{DSC_Macro}()},
\code{\link{DSC_Micro}()},
\code{\link{DSC_R}()},
\code{\link{DSC_Static}()},
\code{\link{DSC_TwoStage}()},
\code{\link{DSC}()},
\code{\link{animate_cluster}()},
\code{\link{evaluate.DSC}},
\code{\link{get_assignment}()},
\code{\link{plot.DSC}()},
\code{\link{predict}()},
\code{\link{prune_clusters}()},
\code{\link{recluster}()}
}
\author{
Michael Hahsler
}
\concept{DSC}
