\name{net.addatt}
\alias{net.addatt}
\title{Add Attributes to Segments of Stream Network}
\description{
 Add attributes to segments of a \code{\link{net.object}},
 generated by either a functional relationship with optional
 noise added, or a distributional property.
}
\usage{
  net.addatt (net, name=NULL, func=NULL, dist=NULL,
    ind="shreve", sd=0.02, arg1=NULL, arg2=NULL, 
    boundscaling=FALSE, outscaling=FALSE, prob=0.01, 
    min=0, max=1, vector=TRUE)
}
\arguments{
  \item{net}{A \code{\link{net.object}}.}
  \item{name}{name of the attribute to be added
    (if \code{! vector)}).}
  \item{func}{name of the functional form, see details.}
  \item{dist}{name of the distribution function, see details.}
  \item{ind}{the independent variable for functional values.}
  \item{sd}{standard deviation for added noise to \code{func}
    output.  Used as the proportion of the range of the produced
    values.}
  \item{arg1}{first argument to distribution functions, e.g.,
    shape1, mean, etc.  See details.}
  \item{arg2}{second argument to distribution functions.}
  \item{boundscaling}{if \code{TRUE}, scale distribution values to
    either absolute bounds of distribution or to the \code{prob}
    and/or \code{1-prob} quantile; implies \code{outscaling} is
    \code{true}.}
  \item{outscaling}{if \code{TRUE}, scale return values to
    \code{[min, max]}.}
  \item{prob}{probability value for scaling distributions.}
  \item{min}{minimum value for scaling output values.}
  \item{max}{maximum value for scaling output values.}
  \item{vector}{if \code{TRUE}, return a vector else a field
    in \code{$segs}.}
}
\details{
 Functional relationships create a new attribute as a function of
 an existing attribute.  Supported functions:
  \tabular{l}{
    Linear\cr
    NegLinear\cr
    Exponential\cr
    NegExponential\cr
    Sigmoid\cr
    RevSigmoid\cr
    Logarithmic\cr
    RevLogarithmic\cr
    Sinusoidal\cr
    Quadratic
  }

 Distributions create a new attribute with designated
 distributional properties.  The assignment of distributed
 values is not controlled for spatial autocorrelation.  Supported
 distributions:
  \tabular{ll}{
    Uniform         \tab = runif (n, min=arg1, max=arg2)\cr
    Normal          \tab = rnorm (n, mean=arg1, sd=arg2)\cr
    Ramp            \tab = rbeta (n, shape1=arg1, shape2=arg2)\cr
    NegRamp         \tab = rbeta (n, shape1=arg1, shape2=arg2)\cr
    Exponential     \tab = rbeta (n, shape1=arg1, shape2=arg2)\cr
    NegExponential  \tab = rbeta (n, shape1=arg1, shape2=arg2)\cr
    Lognormal       \tab = rlnorm (n, meanlog=arg1, sdlog=arg2)\cr
    Weibull         \tab = rweibull (n, shape=arg1, scale=arg2)\cr
    Unimodal        \tab = rbeta (n, shape1=arg1, shape2=arg2)\cr
    Logistic        \tab = rlogis (n, location=arg1, scale=arg2)
  }

 where the default values of \code{arg1} and \code{arg2} are:
  \tabular{ll}{
    Uniform         \tab = c(0, 1)\cr
    Normal          \tab = c(0, 1)\cr
    Ramp            \tab = c(2, 1)\cr
    NegRamp         \tab = c(1, 2)\cr
    Exponential     \tab = c(100, 1)\cr
    NegExponential  \tab = c(1, 100)\cr
    Lognormal       \tab = c(0, 0.4)\cr
    Weibull         \tab = c(100, 100)\cr
    Unimodal        \tab = c(2, 2)\cr
    Logistic        \tab = c(0, 1)
  }

 and the \code{Boundscaling} values are:
  \tabular{ll}{
    Uniform         \tab = c(0, 1)\cr
    Normal          \tab = c(qnorm (prob, mean=arg1, sd=arg2), 
                      qnorm (1-prob, mean=arg1, sd=arg2))\cr
    Ramp            \tab = c(0, 1)\cr
    NegRamp         \tab = c(0, 1)\cr
    Exponential     \tab = c(0, 1)\cr
    NegExponential  \tab = c(0, 1)\cr
    Lognormal       \tab = c(0, qlnorm (1-prob, meanlog=arg1, sdlog=arg2))\cr
    Weibull         \tab = c(0, qweibull (1-prob, shape=arg1, scale=arg2))\cr
    Unimodal        \tab = c(0, 1)\cr
    Logistic        \tab = c(qlogis (prob, location=arg1, scale=arg2),
                      qlogis (1-prob, location=arg1, scale=arg2))
  }
}
\value{
 If \code{vector} is TRUE, then a vector of the attribute
 values in segment order, else a \code{\link{net.object}}
 with the attribute added to \code{$segs}.}
\author{Denis White, \email{white.denis@epa.gov} }
\seealso{
  \code{\link{net.object}}
  \code{\link{net.addsegs}}
  \code{\link{runif}}
  \code{\link{rnorm}}
  \code{\link{rlnorm}}
  \code{\link{rbeta}}
  \code{\link{rweibull}}
  \code{\link{rlogis}}
}
\examples{
  # Q model random net
  net <- net.qmodel (10)

  # add segments
  net <- net.addsegs (net)

  # add attribute based on normal distribution
  net <- net.addatt (net, name="normal", dist="Normal",
    boundscaling=TRUE, vector=FALSE)
  classes <- net.group (net, segatt="normal", ngroups=7,
    method="equalInterval")
  net.map (net, group=classes$group, lwd=2)
  net.map.key (0.8, 0.1, labels=round(classes$cuts, 2), 
    sep=0, head="normal", horizontal=FALSE)

  # make attribute based on log of shreve order
  att <- net.addatt (net, name="slope", func="Logarithmic",
    ind="shreve", outscaling=TRUE, vector=TRUE)
  att <- (1 - att) * 10
  classes <- net.group (net, att, ngroups=7,
    method="equalInterval")
  net.map (net, group=classes$group, lwd=2)
  net.map.key (0.6, 0.1, labels=round(classes$cuts, 0), 
    sep=0, head="log.shreve", horizontal=TRUE)
}
\keyword{datagen}
\keyword{manip}
