% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match_functions.R
\name{strata_match}
\alias{strata_match}
\title{Strata Match}
\usage{
strata_match(object, model = NULL, method = "prop", k = 1)
}
\arguments{
\item{object}{a strata object}

\item{model}{(optional) formula for matching.  If left blank, \emph{all}
columns of the analysis set in \code{object} will be used as covariates in
the propensity model or mahalanobis match (except outcome, treatment and
stratum)}

\item{method}{either "prop" for propensity score matching based on a glm fit
with model \code{model}, or "mahal" for mahalanobis distance matching by
the covariates in \code{model}.}

\item{k}{the number of control individuals to be matched to each treated
individual.  If \code{"k = full"} is used, fullmatching is done instead of
pairmatching}
}
\value{
a named factor with matching assignments
}
\description{
Match within strata in series using optmatch. Note that this function 
requires that the R package \code{optmatch} is installed.
}
\examples{
# make a sample data set
set.seed(1)
dat <- make_sample_data(n = 75)

# stratify with auto_stratify
a.strat <- auto_stratify(dat, "treat", outcome ~ X2, size = 25)

# 1:1 match based on propensity formula: treat ~ X1 + X2
# Requires optmatch package to be installed.
\dontshow{if (requireNamespace("optmatch", quietly = TRUE)) \{}
strata_match(a.strat, model = treat ~ X1 + X2, k = 1)
\dontshow{\}}

# full match within strata based on mahalanobis distance.
# Requires optmatch package to be installed.
\dontshow{if (requireNamespace("optmatch", quietly = TRUE)) \{}
strata_match(a.strat, model = treat ~ X1 + X2, method = "mahal", k = 1)
\dontshow{\}}
}
\seealso{
\url{https://cran.r-project.org/package=optmatch}
}
