% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ldNe.R
\name{ldNe}
\alias{ldNe}
\title{ldNe}
\usage{
ldNe(g, maf.threshold = 0, by.strata = FALSE, ci = 0.95)
}
\arguments{
\item{g}{a \linkS4class{gtypes} object.}

\item{maf.threshold}{smallest minimum allele frequency permitted to include 
a locus in calculation of Ne.}

\item{by.strata}{apply the \code{maf.threshold} by strata. If \code{TRUE}
then any locus that is below this threshold in any strata will be removed 
from the calculation of Ne for every stratum. Otherwise, loci are removed 
only if they are below the \code{maf.threshold} in the stratum for which 
Ne is calculated.}

\item{ci}{central confidence interval.}
}
\value{
a numeric matrix with one row per strata and the following columns:
\describe{
 \item{\code{S}}{harmonic mean of sample size across pairwise comparisons of loci}
 \item{\code{num.comp}}{number of pairwise loci comparisons used}
 \item{\code{mean.rsq}}{mean r^2 over all loci}
 \item{\code{mean.E.rsq}}{mean expected r^2 over all loci}
 \item{\code{Ne}}{estimated Ne}
 \item{\code{param.lci, param.uci}}{parametric lower and upper CIs}
}
}
\description{
Estimate Ne from linkage disequilibrium based on Pearson 
  correlation approximation following Waples et al 2016. Adapted from code 
  by R. Waples and W. Larson.
}
\references{
Waples, R.S. 2006. A bias correction for estimates of effective population 
  size based on linkage disequilibrium at unlinked gene loci. 
  Conservation Genetics 7:167-184. \cr\cr
  Waples RK, Larson WA, and Waples RS. 2016. Estimating contemporary 
  effective population size in non-model species using linkage 
  disequilibrium across thousands of loci. Heredity 117:233-240; 
  doi:10.1038/hdy.2016.60
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
