% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/dup.genotypes.R
\name{dup.genotypes}
\alias{dup.genotypes}
\title{Duplicate Genotypes}
\usage{
dup.genotypes(g, label, num.shared = 0.8, num.cores = 1)
}
\arguments{
\item{g}{a \code{\link[strataG]{gtypes}} object.}

\item{label}{label for output folder and prefix for files.}

\item{num.shared}{either number of loci or percentage of loci two individuals must share
to be considered duplicate individuals.}

\item{num.cores}{number of CPU cores to use. Value is passed to \code{\link[parallel]{mclapply}}.}
}
\value{
a data.frame with the following columns:
\tabular{ll}{
  \code{id1, id2} \tab sample ids.\cr
  \code{strata1, strata2} \tab sample strata.\cr
  \code{num.loci.genotyped} \tab number of loci genotyped for both samples.\cr
  \code{num.loci.shared} \tab number of loci shared between both samples.\cr
  \code{percent.loci.shared} \tab percent of loci genotyped for both samples that are shared.\cr
  \code{mismatch.loci} \tab loci where the two samples do not match.\cr
}
}
\description{
Duplicate Genotypes
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

