% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/create.consensus.R
\name{create.consensus}
\alias{create.consensus}
\title{Consensus Sequence}
\usage{
create.consensus(x, ignore.gaps = FALSE)
}
\arguments{
\item{x}{a \code{\link{gtypes}} object with aligned sequences, or a list of aligned DNA sequences.}

\item{ignore.gaps}{logical. Ignore gaps at a site when creating consensus. If true, then bases with a
  gap are removed before consensus is calculated. If false and a gap is present, then the result is a gap.}
}
\value{
A character vector of the consensus sequence.
}
\description{
Return a consensus sequence from set of aligned sequences, introducing IUPAC ambiguity
  codes where necessary.
}
\examples{
data(dolph.seqs)
create.consensus(dolph.seqs)
}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}

