% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst_data.R
\name{stratEst.data}
\alias{stratEst.data}
\title{Creates a stratEst.data object.}
\usage{
stratEst.data(
  data,
  choice = "choice",
  input = c("input"),
  input.lag = 0,
  input.sep = "",
  id = "id",
  game = "game",
  period = "period",
  add = NULL,
  drop = NULL
)
}
\arguments{
\item{data}{a \code{data.frame} in the long format.}

\item{choice}{a character string. The variable in \code{data} which contains the discrete choices. Default is \code{"choice"}.}

\item{input}{a character string. The names of the input generating variables in \code{data}. At least one input generating variable has to be specified. Default is \code{c("input")}.}

\item{input.lag}{a numeric vector. The time lag in periods of the input generating variables. The vector must have as many elements as variables specified in the object \code{input}. Default is zero.}

\item{input.sep}{a character string. Separates the input generating variables. Default is \code{""}.}

\item{id}{a character string. The name of the variable in \code{data} that identifies observations of the same individual. Default is \code{"id"}.}

\item{game}{a character string. The name of the variable in \code{data} that identifies observations of the same game. Default is \code{"game"}.}

\item{period}{a character string. The name of the variable in \code{data} that identifies the periods of a game. Default is \code{"period"}.}

\item{add}{a character vector. The names of variables in the global environment that should be added to the \code{stratEst.data} object. Default is \code{NULL}.}

\item{drop}{a character vector. The names of variables in \code{data} that should be dropped. Default is \code{NULL}.}
}
\value{
A \code{stratEst.data} object. A data frame in the long format with the following variables:
\item{id}{the variable that identifies observations of the same individual.}
\item{game}{the variable that identifies observations of the same game.}
\item{period}{the period of the game.}
\item{choice}{the discrete choices.}
\item{input}{the inputs.}
}
\description{
Creates a stratEst.data object.
}
\details{
The data generation function of the package.
}
\references{
Dal Bo P, Frechette GR (2011). "The Evolution of Cooperation in Infinitely Repeated Games: Experimental Evidence." \emph{American Economic Review}, 101(1), 411-429.

Fudenberg D, Rand DG, Dreber A (2012). "Slow to Anger and Fast to Forgive: Cooperation in an Uncertain World." \emph{American Economic Review}, 102(2), 720-749.

Wang Z, Xu B, Zhou HJ (2014). "Social Cycling and Conditional Responses in the Rock-Paper-Scissors Game." \emph{Scientific Reports}, 4(1), 2045-2322.

#' @examples
## Transform the rock-paper-scissors data of Wang, Xu, and Zhou (2014)
data.WXZ2014 <- stratEst.data(WXZ2014, input = c("choice"), choice = "choice", input.lag = 1)

## Transform the prisoner's dilemma data of Dal Bo and Frechette (2011).
data.DF2011 <- stratEst.data(DF2011, choice ="choice", input =c("choice","other.choice"), input.lag = 1)

#' ## Transform the prisoner's dilemma data of Fudenberg, Rand, and Dreber (2012).
data.FRD2012 <- stratEst.data(data = FRD2012, choice ="choice", input =c("last.choice","last.other"))
}
