#' Data of Dal Bo and Frechette (2011)
#'
#' A dataset with observations from the repeated prisoner's dilemma experiment of Dal Bo and Frechette (2011).
#'
#' @format A data frame with 7358 rows and 6 variables:
#' \describe{
#'   \item{treatment}{A treatment identifier of the experiment.}
#'   \item{id}{Variable which identifies a participant.}
#'   \item{supergame}{The supergame number.}
#'   \item{period}{The period of the supergame.}
#'   \item{cooperation}{A dummy variable  which is one if the participant cooperated in the current period.}
#'   \item{other_cooperation}{A dummy variable which is one if the partner in the current match cooperated in the current period.}
#' }
#' @usage data(DF2011)
#' @source \url{https://www.aeaweb.org/articles?id=10.1257/aer.101.1.411}
#' @references
#' Dal Bo, P. and G. R. Frechette (2011): The evolution of cooperation in infinitely repeated games: Experimental evidence, \emph{American Economic Review}, 101, 411-429.
#'
"DF2011"
