% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_funs.R
\name{route_rolling_average}
\alias{route_rolling_average}
\title{Return smoothed averages of vector}
\usage{
route_rolling_average(x, n = 3)
}
\arguments{
\item{x}{Numeric vector to smooth}

\item{n}{The window size of the smoothing function.
The default, 3, will take the mean of values before, after and including
each value.}
}
\description{
This function calculates a simple rolling mean in base R.
It is useful for calculating route characteristics such as mean
distances of segments and changes in gradient.
}
\examples{
y <- od_data_routes$elevations[od_data_routes$route_number == 2]
y
route_rolling_average(y)
route_rolling_average(y, n = 1)
route_rolling_average(y, n = 2)
route_rolling_average(y, n = 3)
}
\seealso{
Other route_funs: 
\code{\link{route_average_gradient}()},
\code{\link{route_rolling_diff}()},
\code{\link{route_rolling_gradient}()},
\code{\link{route_sequential_dist}()},
\code{\link{route_slope_matrix}()},
\code{\link{route_slope_vector}()}
}
\concept{route_funs}
