% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/od-funs.R
\name{line2route}
\alias{line2route}
\title{Convert straight SpatialLinesDataFrame from flow data into routes}
\usage{
line2route(ldf, ...)
}
\arguments{
\item{ldf}{A SpatialLinesDataFrame or data.frame of coordinates produced by
\code{\link{line2df}}}

\item{...}{Arguements passed to \code{\link{route_cyclestreet}}}
}
\description{
Convert straight SpatialLinesDataFrame from flow data into routes
}
\section{Details}{


See \code{\link{route_cyclestreet}} and other route functions for details
}
\examples{
data(flowlines) # load demo flowlines dataset
\dontrun{
# Don't run as requires gdal dependency, can cause issues
library(rgdal)
flowlines <- spTransform(flowlines, CRS("+init=epsg:27700"))
flowlines <- flowlines[rgeos::gLength(flowlines, byid = TRUE) > 0,]
flowlines <- spTransform(flowlines, CRS("+init=epsg:4326"))
plot(flowlines)

cckey <- readLines("~/Dropbox/dotfiles/cyclestreets-api-key-rl")
Sys.setenv(CYCLESTREET = cckey)
routes_fast <- line2route(l = flowlines, plan = "fastest")
routes_slow <- line2route(l = flowlines, plan = "quietest", silent = TRUE)
}

flowlines <- flowlines[flowlines$Area.of.residence != flowlines$Area.of.workplace,]
# Save the route data (uncomment if this changes)
# devtools::use_data(routes_fast, overwrite = TRUE)
# devtools::use_data(routes_slow, overwrite = TRUE)

if(!exists("routes_fast")){
  data(routes_fast, routes_slow) # load routes
}

plot(flowlines)
lines(routes_fast, col = "red")
lines(routes_slow, col = "green")

# Plot for a single line to compare 'fastest' and 'quietest' route
n = 18
plot(flowlines[n,])
lines(routes_fast[n,], col = "red")
lines(routes_slow[n,], col = "green")
}

