% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_session_parties.R
\name{get_session_parties}
\alias{get_session_parties}
\title{Parliamentary parties in specified session}
\usage{
get_session_parties(sessionid = NA, good_manners = 0)
}
\arguments{
\item{sessionid}{Character string indicating the id of the parliamentary session to retrieve.}

\item{good_manners}{Integer. Seconds delay between calls when making multiple calls to the same function}
}
\value{
A data.frame with the following variables:\tabular{ll}{
    \tab  \cr
   \strong{response_date} \tab Date of data retrieval \cr
   \strong{version} \tab Data version from the API \cr
   \strong{id} \tab Party id \cr
   \strong{name} \tab Party name \cr
   \strong{represented_party} \tab Logical indication of whether party was represented \cr
   \strong{session_id} \tab Session id \cr
   \strong{period_id} \tab Parliamentary period id \cr
}
}
\description{
A function for retrieving Norwegian parliamentary parties for a specified parliamentary session
}
\examples{

\dontrun{

parties <- get_session_parties("2003-2004")
parties

}
 
}
\seealso{
\link{get_all_parties}
}
