% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.rule.surv.R
\name{plot.rule.surv}
\alias{plot.rule.surv}
\title{Plot Stopping Rule (Survival Data)}
\usage{
\method{plot}{rule.surv}(
  x,
  xlim = c(0, max(x$Rule[, 1])),
  ylim = c(0, max(x$Rule[, 2]) + 1),
  xlab = "Total Exposure Time",
  ylab = "# Events",
  ...
)
}
\arguments{
\item{x}{A 'rule.surv' object calculated by \code{calc.rule.surv()} function}

\item{xlim}{The x limits (x1, x2) of the plot. Note that x1 > x2 is allowed and leads to a ‘reversed axis’.}

\item{ylim}{The y limits of the plot.}

\item{xlab}{The title for the x axis}

\item{ylab}{The title for the y axis}

\item{...}{Other parameters passed to the \code{plot} function.}
}
\value{
No return value; function solely generates a plot
}
\description{
Display a stopping rule graphically as a curve for time-to-event data
}
\examples{
pocock.rule <- calc.rule.surv(n = 30, tau = 100, p0 = 0.1, type = "Pocock", alpha = 0.05)
plot(pocock.rule, col = "red")
}
