% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc.rule.bin.R
\name{calc.rule.bin}
\alias{calc.rule.bin}
\title{Stopping Rule Calculation (Binary Data)}
\usage{
calc.rule.bin(ns, p0, alpha, type, param = NULL, iter = 50)
}
\arguments{
\item{ns}{A vector of sample sizes at which sequential testing is performed}

\item{p0}{The toxicity probability under the null hypothesis}

\item{alpha}{The desired type I error / false positive rate for the stopping rule}

\item{type}{The method used for constructing the stopping rule. Choices include a Pocock test ("Pocock"), an O'Brien-Fleming test ("OBF"), a Wang-Tsiatis test ("WT"), the Bayesian beta-binomial method ("BB") proposed by Geller et al. 2003, the Bayesian beta-binomial method ("CC") proposed by Chen and Chaloner 2006, a truncated SPRT ("SPRT"), and a maximized SPRT ("MaxSPRT").}

\item{param}{Extra parameter(s) needed for certain stopping rule methods. For binomial Wang-Tsiatis tests, this is the Delta parameter. For the Geller et al. method, this is the pair of hyperparameters (a,b) for the beta prior on the toxicity probability. For Chen and Chaloner's method, this is the pair of hyperparameters (a,b) for the beta prior on the toxicity probability, the targeted alternative toxicity probability p1, and the threshold nu for the posterior probability that p > p1. For modified SPRT, this is the targeted alternative toxicity probability p1.}

\item{iter}{The number of iterations used to search for the boundary}
}
\value{
A rule.bin object, which is a list with the following elements: Rule, a two-column matrix with the sample sizes \code{ns} and their corresponding rejection boundaries; ns; p0; alpha; type; param; and cval
}
\description{
Calculate a stopping rule for safety monitoring, treating toxicities as binary data
}
\examples{
# Binomial Pocock test in 50 patient cohort at 10\% level, expected toxicity probability of 20\%
calc.rule.bin(ns=1:50,p0=0.20,alpha=0.10,type="Pocock")
}
\references{
Chen, C. and Chaloner, K. (2006). A Bayesian stopping rule for a single arm study: With a case study of stem cell transplantation. \emph{Statistics in Medicine} \strong{25(17)}, 2956-66.

Geller, N.L., Follman, D., Leifer, E.S. and Carter, S.L. (2003). Design of early trials in stem cell transplantation: a hybrid frequentist-Bayesian approach. \emph{Advances in Clinical Trial Biostatistics}.

Goldman, A.I. (1987). Issues in designing sequential stopping rules for monitoring side effects in clinical trials. \emph{Controlled Clinical Trials}  \strong{8(4)}, 327-37.

Ivanova, A., Qaqish, B.F. and Schell, M.J. (2005). Continuous toxicity monitoring in phase II trials in oncology. \emph{Biometrics} \strong{61(2)}, 540-545.

Kulldorff, M., Davis, R.L., Kolczak, M., Lewis, E., Lieu, T. and Platt, R. (2011). A maximized sequential probability ratio test for drug and vaccine safety surveillance. \emph{Sequential Analysis} \strong{30(1)}, 58-78.

Martens, M.J. and Logan, B.R. (2023). Statistical Rules for Safety Monitoring in Clinical Trials. \emph{Clinical Trials} \strong{Article in press}.

Pocock, S.J. (1977). Group sequential methods in the design and analysis of clinical trials. \emph{Biometrika} \strong{64(2)}, 191-199.

Wang, S.K. and Tsiatis, A.A. (1987). Approximately optimal one-parameter boundaries for group sequential trials. \emph{Biometrics} \strong{193-199}.
}
