% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers_free.R
\name{update_hess_vec}
\alias{update_hess_vec}
\title{Update Hessian-vector product (SQN)}
\usage{
update_hess_vec(optimizer, hess_vec)
}
\arguments{
\item{optimizer}{An `SQN_free` optimizer which after the last run had requested a new Hessian-vector evaluation.}

\item{hess_vec}{The (expected) value of the Hessian evaluated at the values of `x` that were returned in the
request, multiplied by the vector that was returned in the same request. Must be a numeric vector.}
}
\value{
No return value (object is updated in-place).
}
\description{
Update the (expected) values of the Hessian-vector product in an `SQN_free` object,
after it has been requested by the optimizer (do NOT update it otherwise).
}
