% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{turb_pars_wide_example}
\alias{turb_pars_wide_example}
\title{Example of turbine and windfarm parameters stored in wide format}
\format{
A 3 x 51 data frame, with the turbine and windfarm parameters (columns) for
each of the 3 development scenarios (rows). Columns include:
\describe{
\item{TurbineModel }{The turbine/windfarm scenario ID}
\item{Blades}{Nr of blades}
\item{RotorRadius}{Mean of rotor radius}
\item{RotorRadiusSD}{SD of rotor radius}
\item{HubHeightAdd}{Mean of air gap, the distance between sea surface and lowest tip height.}
\item{HubHeightAddSD}{SD of air gap, as explained above.}
...
}
}
\usage{
turb_pars_wide_example
}
\description{
A data frame of (fake) data on turbine and wind farm features for 3 scenarios.
}
\details{
Intended to illustrate the application of \code{stoch_scrm()} to a multiple
scenario setting, where parameter data is available from tables in wide format.
}
\keyword{datasets}
