% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/STMfunctions.R
\name{js.estimate}
\alias{js.estimate}
\title{A James-Stein Estimator Shrinking to a Uniform Distribution}
\usage{
js.estimate(prob, ct)
}
\arguments{
\item{prob}{the MLE estimate of the discrete probability distribution}

\item{ct}{the count of words observed to estimate that distribution}
}
\description{
A primarily internal function used in \code{\link{calcfrex}}.
}
\details{
This calculates a James-Stein type shrinkage estimator for a discrete probability
distribution regularizing towards a uniform distribution. The amount of shrinkage
is a function of the variance of MLE and the L2 norm distance from the uniform.

This function is based off the ideas in Hausser and Strimmer (2009)
}
\references{
Hausser, Jean, and Korbinian Strimmer. "Entropy inference and the James-Stein estimator, 
with application to nonlinear gene association networks." Journal of Machine Learning Research 
10.Jul (2009): 1469-1484.
}
\keyword{internal}
