% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{fct_reorg}
\alias{fct_reorg}
\title{Reorganize a factor after "re-leveling" it}
\usage{
fct_reorg(fac, ...)
}
\arguments{
\item{fac}{a character or factor vector}

\item{...}{optional parameters to be supplied to \pkg{forcats} functions.}
}
\value{
This function takes a character or factor vector and first re-levels it before re-coding certain values. The end
result is a factor.
}
\description{
\code{fct_reorg()} is a \pkg{forcats} hack that reorganizes a factor after re-leveling it. It has been
situationally useful in my coefficient plots over the years.
}
\details{
Solution comes by way of this issue on Github: \url{https://github.com/tidyverse/forcats/issues/45}
}
\examples{

x<-factor(c("a","b","c"))
fct_reorg(x, B="b", C="c")

}
