% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.test.cor}
\alias{size.test.cor}
\title{Sample size for a test of a Pearson or partial correlation}
\usage{
size.test.cor(alpha, pow, cor, s, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{cor}{planning value of correlation}

\item{s}{number of control variables}

\item{h}{hypothesized value of slope}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to test a Pearson or a partial correlation
with desired power. Set s = 0 for a Pearson correlation. Set the correlation
planning value to the smallest value within a plausible range for a
conservatively large sample size.
}
\examples{
size.test.cor(.05, .9, .45, 0, 0)

# Should return:
#      Sample size
# [1,]          48
 

}
