% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagk.R
\name{lagk}
\alias{lagk}
\title{Lag a vector}
\usage{
lagk(x, k, na = FALSE, cst = FALSE)
}
\arguments{
\item{x}{A vector.}

\item{k}{integer. The number of lags. 
If \code{k < 0}, la serie est avancee au lieu d'etre retardee.}

\item{na}{logical. If \code{na = TRUE} and \code{k > 0} 
(resp. \code{k < 0}), the \code{|k|} holes created in the lagged vector 
are put to \code{NA}; otherwise, the imputation depends on \code{cst}.}

\item{cst}{logical. 
If \code{na = FALSE} and \code{cst = TRUE}, the \code{|k|} holes 
created in the lagged vector are put to \code{x[[1L]]} 
(or to \code{x[[length(x)]]} if \code{k < 0}). 
If \code{na = FALSE} and \code{cst = FALSE}, 
these \code{|k|} holes are imputed by the \code{k} 
first values of \code{x} (or the \code{k} last values if \code{k < 0}).}
}
\value{
A vector of the same type and length as \code{x}.
}
\description{
This function computes a lagged vector, shifting it back or forward.
}
\examples{
v <- sample(1:10)
print(v)
lagk(v, 1)
lagk(v, 1, na = TRUE)
lagk(v, -2)
lagk(v, -3, na = TRUE)
lagk(v, -3, na = FALSE, cst = TRUE)
lagk(v, -3, na = FALSE)

}

