% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blanks.R
\name{blankPDF}
\alias{blankPDF}
\title{create white background empty PDF}
\usage{
blankPDF(file, height = 1, width = 3.5,
  messg = "Your Logo Could Be Here", pointsize = 12, col = "gray50")
}
\arguments{
\item{file}{A file name for output}

\item{height}{inches}

\item{width}{inches}

\item{messg}{Default is a reminder statement, but set "" if you don't want it.}

\item{pointsize}{Default is 12}

\item{col}{Color for text in \code{messg} parameter. Default is \code{gray50}}
}
\value{
NULL is returned if file was created. Otherwise error is reported.
}
\description{
Sometimes you need a placeholder. If you do, this is it!
}
\examples{
tdir <- tempdir()
dir.create(file.path(tdir, "blanks"), recursive = TRUE)
fn1 <- file.path(tdir, "blanks", "blank1.pdf")
blankPDF(file = fn1, messg = "Do you want a message?")
## Please inspect
if(interactive()) browseURL(fn1)
fn2 <- file.path(tdir, "blanks", "blank2.pdf")
blankPDF(file = fn2, height = 2, width = 3, messg = "")
if(interactive()) browseURL(fn2)
## delete test directory
unlink(file.path(tdir, "blanks"), recursive = TRUE)

}
\author{
Paul Johnson
}
