% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/detectSerieOut.R
\name{plot.serieOut}
\alias{plot.serieOut}
\title{Plot outliers for series of observations}
\usage{
\method{plot}{serieOut}(
  x,
  ...,
  genotypes = NULL,
  useTimeNumber = FALSE,
  timeNumber = NULL,
  title = NULL,
  output = TRUE
)
}
\arguments{
\item{x}{An object of class \code{serieOut}.}

\item{...}{Ignored.}

\item{genotypes}{A character vector indicating which genotypes should be
plotted.}

\item{useTimeNumber}{Should the timeNumber be used instead of the timePoint
in the labels on the x-axis?}

\item{timeNumber}{If \code{useTimeNumber = TRUE}, a character vector
indicating the column containing the numerical time to use.}

\item{title}{A character string used as title for the plot. If \code{NULL} a
default title is added to the plot depending on \code{plotType}.}

\item{output}{Should the plot be output to the current device? If
\code{FALSE} only a (list of) ggplot object(s) is invisibly returned. Ignored if
\code{outFile} is specified.}
}
\value{
A list of ggplot objects is invisibly returned.
}
\description{
Plot the fitted spline, correlation matrix and PCA biplot for each of the
genotypes. Outlying series of observations are shown as filled dots in the
fitted spline plot, other observations are shown as open dots.
}
\examples{
\donttest{
## The data from the Phenovator platform have been corrected for spatial
## trends and outliers for single observations have been removed.

## Fit P-splines on a subset of genotypes
subGenoVator <- c("G160", "G151")
fit.spline <- fitSpline(inDat = spatCorrectedVator,
                        trait = "EffpsII_corr",
                        genotypes = subGenoVator,
                        knots = 50)

## Extract the data.frames with predicted values and P-Spline coefficients.
predDat <- fit.spline$predDat
coefDat <- fit.spline$coefDat

## The coefficients are then used to tag suspect time courses.
outVator <- detectSerieOut(corrDat = spatCorrectedVator,
                           predDat = predDat,
                           coefDat = coefDat,
                           trait = "EffpsII_corr",
                           genotypes = subGenoVator,
                           thrCor = 0.9,
                           thrPca = 30)

## The `outVator` can be visualized for selected genotypes.
plot(outVator, genotypes = "G151")
}

}
\seealso{
Other functions for detecting outliers for series of observations: 
\code{\link{detectSerieOut}()},
\code{\link{removeSerieOut}()}
}
\concept{functions for detecting outliers for series of observations}
