/*
 * Decompiled with CFR 0.152.
 */
package phase;

import beagleutil.PbwtDivUpdater;
import ints.IndexArray;
import ints.WrappedIntArray;
import java.util.Arrays;
import java.util.Random;
import java.util.stream.IntStream;
import phase.CodedSteps;
import phase.FixedPhaseData;
import phase.Ibs2;
import phase.PbwtIbsData;
import phase.PhaseData;
import phase.Steps;
import vcf.XRefGT;

public final class PbwtPhaseIbs {
    private final PhaseData phaseData;
    private final XRefGT allHaps;
    private final WrappedIntArray[] ibsHaps;

    public PbwtPhaseIbs(PhaseData phaseData, CodedSteps codedSteps, boolean bl) {
        PbwtPhaseIbs.checkConsistency(phaseData, codedSteps);
        this.phaseData = phaseData;
        this.allHaps = codedSteps.allHaps();
        PbwtIbsData pbwtIbsData = new PbwtIbsData(phaseData, codedSteps);
        this.ibsHaps = bl ? (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.bwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new) : (WrappedIntArray[])IntStream.range(0, pbwtIbsData.nBatches()).parallel().mapToObj(n -> this.fwdIbsHaps(pbwtIbsData, n)).flatMap(wrappedIntArrayArray -> Arrays.stream(wrappedIntArrayArray)).toArray(WrappedIntArray[]::new);
    }

    private static void checkConsistency(PhaseData phaseData, CodedSteps codedSteps) {
        FixedPhaseData fixedPhaseData = phaseData.fpd();
        if (fixedPhaseData.stage1Steps() != codedSteps.steps() || fixedPhaseData.stage1XRefGT() != codedSteps.refHaps() || fixedPhaseData.targGT().samples() != codedSteps.targSamples()) {
            throw new IllegalArgumentException("inconsistent data");
        }
    }

    private WrappedIntArray[] bwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.min(n6 + pbwtIbsData.nOverlapSteps(), n4);
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7 - 1).toArray();
        for (n3 = n7 - 1; n3 >= n6; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n6 - 1; n3 >= n5; --n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.bwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            wrappedIntArrayArray[n3 - n5] = this.getBwdIbsHaps(n3, nArray, nArray2, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray[] fwdIbsHaps(PbwtIbsData pbwtIbsData, int n) {
        IndexArray indexArray;
        int n3;
        int n4 = pbwtIbsData.codedSteps().steps().size();
        int n5 = n * pbwtIbsData.stepsPerBatch();
        int n6 = Math.min(n5 + pbwtIbsData.stepsPerBatch(), n4);
        int n7 = Math.max(0, n5 - pbwtIbsData.nOverlapSteps());
        assert (n5 < n4);
        WrappedIntArray[] wrappedIntArrayArray = new WrappedIntArray[n6 - n5];
        int n8 = pbwtIbsData.nHaps();
        PbwtDivUpdater pbwtDivUpdater = new PbwtDivUpdater(n8);
        int[] nArray = IntStream.range(0, n8).toArray();
        int[] nArray2 = IntStream.range(0, n8 + 1).map(n2 -> n7).toArray();
        for (n3 = n7; n3 < n5; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
        }
        for (n3 = n5; n3 < n6; ++n3) {
            indexArray = pbwtIbsData.codedSteps().get(n3);
            pbwtDivUpdater.fwdUpdate(indexArray, indexArray.valueSize(), n3, nArray, nArray2);
            wrappedIntArrayArray[n3 - n5] = this.getfwdIbsHaps(n3, nArray, nArray2, pbwtIbsData);
        }
        return wrappedIntArrayArray;
    }

    private WrappedIntArray getBwdIbsHaps(int n, int[] nArray, int[] nArray2, PbwtIbsData pbwtIbsData) {
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = pbwtIbsData.codedSteps().steps().start(n);
        int n3 = pbwtIbsData.codedSteps().steps().end(n) - 1;
        int[] nArray3 = new int[pbwtIbsData.nTargHaps()];
        int n4 = n - 2;
        nArray2[nArray.length] = n4;
        nArray2[0] = n4;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= pbwtIbsData.nTargHaps()) continue;
            int n5 = i;
            int n6 = i + 1;
            int n7 = nArray2[n5];
            int n8 = nArray2[n6];
            while (n6 - n5 < pbwtIbsData.nCandidates() && (n <= n7 || n <= n8)) {
                if (n7 <= n8) {
                    n8 = Math.min(nArray2[++n6], n8);
                    continue;
                }
                n7 = Math.min(nArray2[--n5], n7);
            }
            nArray3[nArray[i]] = PbwtPhaseIbs.getMatch(this.phaseData, n2, n3, i, n5, n6, nArray, random);
        }
        return new WrappedIntArray(nArray3);
    }

    private WrappedIntArray getfwdIbsHaps(int n, int[] nArray, int[] nArray2, PbwtIbsData pbwtIbsData) {
        Steps steps = this.phaseData.fpd().stage1Steps();
        Random random = new Random(this.phaseData.seed() + (long)n);
        int n2 = this.phaseData.fpd().targGT().nHaps();
        int n3 = steps.start(n);
        int n4 = steps.end(n) - 1;
        int[] nArray3 = new int[n2];
        int n5 = n + 2;
        nArray2[nArray.length] = n5;
        nArray2[0] = n5;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] >= n2) continue;
            int n6 = i;
            int n7 = i + 1;
            int n8 = nArray2[n6];
            int n9 = nArray2[n7];
            while (n7 - n6 < pbwtIbsData.nCandidates() && (n8 <= n || n9 <= n)) {
                if (n9 <= n8) {
                    n9 = Math.max(nArray2[++n7], n9);
                    continue;
                }
                n8 = Math.max(nArray2[--n6], n8);
            }
            nArray3[nArray[i]] = PbwtPhaseIbs.getMatch(this.phaseData, n3, n4, i, n6, n7, nArray, random);
        }
        return new WrappedIntArray(nArray3);
    }

    private static int getMatch(PhaseData phaseData, int n, int n2, int n3, int n4, int n5, int[] nArray, Random random) {
        int n6 = n5 - n4;
        if (n6 == 1) {
            return -1;
        }
        Ibs2 ibs2 = phaseData.fpd().stage1Ibs2();
        int n7 = nArray[n3] >> 1;
        int n8 = -1;
        int n9 = n4 + random.nextInt(n6);
        for (int i = 0; i < n6 && n8 == -1; ++i) {
            int n10 = nArray[n9] >> 1;
            if (!ibs2.areIbs2(n7, n10, n) && !ibs2.areIbs2(n7, n10, n2)) {
                n8 = nArray[n9];
            }
            if (++n9 != n5) continue;
            n9 = n4;
        }
        return n8;
    }

    public PhaseData phaseData() {
        return this.phaseData;
    }

    public XRefGT allHaps() {
        return this.allHaps;
    }

    public int ibsHap(int n, int n2) {
        return this.ibsHaps[n2].get(n);
    }
}

