/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import java.util.Arrays;

public class IndexSet {
    private final boolean[] inSet;
    private final int[] indices;
    private int size = 0;

    public IndexSet(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(String.valueOf(n));
        }
        this.inSet = new boolean[n + 1];
        this.indices = new int[n + 1];
    }

    public boolean add(int n) {
        if (!this.inSet[n]) {
            this.indices[this.size++] = n;
            this.inSet[n] = true;
            return true;
        }
        return false;
    }

    public boolean contains(int n) {
        return this.inSet[n];
    }

    public int size() {
        return this.size;
    }

    public int maxPermittedElement() {
        return this.indices.length - 1;
    }

    public void clear() {
        int n = this.size;
        for (int i = 0; i < n; ++i) {
            this.inSet[this.indices[i]] = false;
        }
        this.size = 0;
    }

    public int enumeratedValue(int n) {
        if (n >= this.size) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
        return this.indices[n];
    }

    public int[] toArray() {
        return Arrays.copyOf(this.indices, this.size);
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }
}

