% Generated by roxygen2 (4.0.2): do not edit by hand
\name{winsorize}
\alias{winsorise}
\alias{winsorize}
\title{Winsorize a numeric vector}
\usage{
winsorize(x, probs = NULL, cutpoints = NULL, replace = c(cutpoints[1],
  cutpoints[2]), verbose = TRUE)

winsorise(x, probs = NULL, cutpoints = NULL, replace = c(cutpoints[1],
  cutpoints[2]), verbose = TRUE)
}
\arguments{
\item{x}{A vector of values}

\item{probs}{A vector of probabilities that can be used instead of cutpoints. Quantiles are computed as the inverse of the empirical distribution function (type = 1)}

\item{cutpoints}{Cutpoints under and above which are defined outliers. Default is (median - five times interquartile range, median + five times interquartile range). Compared to bottom and top percentile, this takes into account the whole distribution of the vector.}

\item{replace}{Values by which outliers are replaced. Default to cutpoints. A frequent alternative is NA.}

\item{verbose}{Boolean. Should the percentage of replaced values printed?}
}
\description{
Winsorize a numeric vector
}
\examples{
v <- c(1:4, 99)
winsorize(v)
winsorize(v, replace = NA)
winsorize(v, probs = c(0.01, 0.99))
winsorize(v, cutpoints = c(1, 50))
}

