% Generated by roxygen2 (4.0.2): do not edit by hand
\name{graph}
\alias{graph}
\alias{graph_}
\title{Experimental function to graph a dataset}
\usage{
graph(x, ..., along_with = NULL, by = NULL, w = NULL, reorder = TRUE,
  winsorize = TRUE, facet = FALSE, verbose = FALSE, type = if
  (is.null(substitute(along_with))) {     "density" } else {     "lm" })

graph_(x, ..., .dots, along_with = NULL, by = NULL, w = NULL,
  reorder = TRUE, winsorize = TRUE, facet = FALSE, verbose = FALSE,
  type = if (is.null(along_with)) {     "density" } else {     "lm" })
}
\arguments{
\item{x}{A data.table.}

\item{...}{Variables to include. Defaults to all non-grouping variables. See the \link[dplyr]{select} documentation.}

\item{along_with}{A variable that specifies the x axis. Should be specified when "type" is "line", "lm" or "loeless".}

\item{by}{Groups within which variables should be ploted.}

\item{w}{Weights (experimental)}

\item{reorder}{Should the category with the most count be printed first?}

\item{winsorize}{Should variables winsorized?}

\item{facet}{Should different groups graphed in different windows?}

\item{verbose}{Should warnings (regarding missing values, outliers, etc) be printed?}

\item{type}{type of graph among "density", "boxplot", "line", "lm", "loess"}

\item{.dots}{Used to work around non-standard evaluation.}
}
\description{
Experimental function to graph a dataset
}
\examples{
library(data.table)
N <- 100
DT <- data.table(
  id = sample(c("id1","id2","id3"), N, TRUE),
  v1 = sample(c(1:5), N, TRUE),
  v2 = rnorm(N, sd = 20),
  v3 = sample(runif(100, max=100), N, TRUE)
)
DT[, v4 := v3 + rnorm(N, sd = 20)]
graph(DT, by = id)
graph(DT, by = id, facet = TRUE)
graph(DT, by = id, type = "boxplot")
graph(DT, v3, v4, along_with = v2, by = id, type = "loess")
}

