% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.dist.R
\name{graph.dist}
\alias{graph.dist}
\title{Distance Matrix on a List of Graphs}
\usage{
graph.dist(Graphs, dist = "JS", ...)
}
\arguments{
\item{Graphs}{a list of undirected graphs.
If each graph has the  attribute \code{eigenvalues} containing its
eigenvalues , such values will be used to
compute their spectral density.}

\item{dist}{string indicating if you want to use the 'JS' (default), 'L1' or 'L2'
distances. 'JS' means Jensen-Shannon divergence.}

\item{...}{Other relevant parameters for \code{\link{graph.spectral.density}}.}
}
\value{
a distance matrix
}
\description{
Given a list of graphs, \code{graph.dist} builds a distance matrix
according to the Jensen-Shannon divergence, L2 norm, or L1 norm
between the spectral density of the graphs graphs.
}
\examples{
set.seed(1)
g <- list()
for(i in 1:5){
  g[[i]] <- igraph::sample_gnp(n=50, p=0.1)
}
for(i in 6:10){
  g[[i]] <- igraph::sample_gnp(n=50, p=0.5)
}
for(i in 11:15){
 g[[i]] <- igraph::sample_gnp(n=50, p=0.9)
}
graph.dist(g, dist = 'JS')


}
\keyword{distance_matrix}
