% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statGraph.R
\name{fast.spectral.density}
\alias{fast.spectral.density}
\title{Degree-based spectral density}
\usage{
fast.spectral.density(G, from = NULL, to = NULL, npoints = 2000, numCores = 1)
}
\arguments{
\item{G}{The undirected unweighted graph (igraph type) whose spectral
density we want to obtain.}

\item{from}{Lower end of the interval that contain the eigenvalues or
smallest eigenvalue of the adjacency matrix of the graph. The smallest
eigenvalue is used if the value is not given.}

\item{to}{Upper end of the interval that contain the eigenvalues or largest
eigenvalue of the adjacency matrix of the graph. The largest eigenvalue is
used if the value is not given.}

\item{npoints}{Number of discretization points of the interval <\code{from},\code{to}>.}

\item{numCores}{Number of cores to use for parallelization.}
}
\value{
Returns the degree-based spectral density of the graph in the
}
\description{
\code{fast.spectral.density} returns the degree-based spectral density in
the interval <\code{from},\code{to}> by using npoints discretization points.
}
\examples{
set.seed(42)
G <- igraph::sample_smallworld(dim = 1, size = 100, nei = 2, p = 0.2)

# Obtain the degree-based spectral density
density <- fast.spectral.density(G = G, npoints = 80, numCores = 1)
density

}
\references{
Newman, M. E. J., Zhang, X., & Nadakuditi, R. R. (2019).
Spectra of random networks with arbitrary degrees.
Physical Review E, 99(4), 042309.
}
\keyword{eigenvalue_density}
