% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phase2_atree.R
\name{panel_utiltreedepth}
\alias{panel_utiltreedepth}
\title{Create the resource utilization by tree depth plot}
\usage{
panel_utiltreedepth(
  data,
  step = data$config$utiltreenode$step,
  x_start = data$config$limits$start,
  x_end = data$config$limits$end,
  legend = data$config$utiltreedepth$legend
)
}
\arguments{
\item{data}{starvz_data with trace data}

\item{step}{size in milliseconds for the time aggregation step}

\item{x_start}{X-axis start value}

\item{x_end}{X-axis end value}

\item{legend}{enable/disable plot legends}
}
\value{
A ggplot object
}
\description{
Use starvz_data Application and Atree to create a plot that shows the
total resource utilization, painted by tree depth level using geom_ribbon
}
\examples{
\dontrun{
panel_utiltreedepth(starvz_sample_lu, step=100, legend=TRUE)
}
}
