% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/4-model-selection.R
\name{hc.sevt}
\alias{hc.sevt}
\title{Hill-Climb Score optimization}
\usage{
hc.sevt(object, score = function(x) return(-BIC(x)), max_iter = Inf, trace = 0)
}
\arguments{
\item{object}{a staged event tree object}

\item{score}{a function that score staged event tree objects}

\item{max_iter}{the maximum number of iterations per variable}

\item{trace}{integer, if positive information on the progress is
printed to console}
}
\value{
The final staged event tree obtained.
}
\description{
Hill-climbing search of staged event trees with
iterative moving of nodes between stages.
}
\details{
For each variable the node-move that best increase the
score is performed. A node-move is either changing the stage
associate to a node or move the node to a new stage.
}
\examples{
model <- hc.sevt(full(PhDArticles[,1:3], lambda = 1))
summary(model)
}
