% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_stage.R
\name{charge_with_filter,ref_stage-method}
\alias{charge_with_filter,ref_stage-method}
\title{Loading method for ref_stage referential objects searching only those stages existing for a DC and a Taxon}
\usage{
\S4method{charge_with_filter}{ref_stage}(object, dc_selected, taxa_selected)
}
\arguments{
\item{object}{An object of class \link{ref_stage-class}}

\item{dc_selected}{The selected counting device}

\item{taxa_selected}{The selected species}
}
\value{
An S4 object of class \link{ref_stage-class} listing all stages available for one DC and one taxon
}
\description{
Loading method for ref_stage referential objects searching only those stages existing for a DC and a Taxon
}
\examples{
\dontrun{
 dc_selected=6
taxa_selected=2038
 object=new('ref_stage')
 charge_with_filter(object,dc_selected,taxa_selected)
}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
