% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ref_taxa.R
\name{charge_with_filter,ref_taxa-method}
\alias{charge_with_filter,ref_taxa-method}
\title{Loading method for ref_taxa referential objects searching only taxa existing for a DC}
\usage{
\S4method{charge_with_filter}{ref_taxa}(object, dc_selected)
}
\arguments{
\item{object}{An object of class \link{ref_taxa-class}}

\item{dc_selected}{A counting device selected, only taxa attached to this dc are selected}
}
\value{
An S4 object of class \link{ref_taxa-class} with all taxa present on a DC (counting device)
}
\description{
Loading method for ref_taxa referential objects searching only taxa existing for a DC
}
\examples{
\dontrun{
 dc_selected=6
 object=new('ref_taxa')
 charge_with_filter(object,dc_selected=dc_selected)}
}
\author{
Cedric Briand \email{cedric.briand'at'eptb-vilaine.fr}
}
