% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repairCyclicModel.R
\name{repairCyclicModel}
\alias{repairCyclicModel}
\title{Repairing a SEM model that is cyclic.}
\usage{
repairCyclicModel(stringModel = NULL, numVar = NULL, longitudinal = NULL)
}
\arguments{
\item{stringModel}{binary vector with length
\code{n^2+(n(n-1))} if \code{longitudinal = TRUE},
or \code{n(n-1)} if
\code{FALSE}, where \code{n} is the number of variables (\code{numVar}).}

\item{numVar}{number of variables.}

\item{longitudinal}{\code{TRUE} for longitudinal data,
and \code{FALSE} for cross-sectional data.}
}
\value{
a binary vector with the same length of input, representing a
repaired model (acyclic).
}
\description{
Repairing a SEM model that is cyclic.
}
\details{
The main idea of this function is to seek cyclic(s) with
any possible length from a given model, and then to cut the cyclic,
so as to make the model acyclic. Moreover, this function is used in
\code{\link{stableSpec}} to ensure no cyclic model in the computation.
}
\examples{
\donttest{
num_vars <- 6
longi_a <- FALSE
longi_b <- TRUE

# Assume that the generated model below is cyclic
# a cross-sectional model
model_a <- round(runif(num_vars * num_vars))
# a longitudinal model
model_b <- c(round(runif(num_vars * num_vars)),
round(runif(num_vars * (num_vars-1))))

repaired_model_a <- repairCyclicModel(stringModel=model_a, numVar=num_vars,
longitudinal=longi_a)

repaired_model_b <- repairCyclicModel(stringModel=model_b, numVar=num_vars,
longitudinal=longi_b)

repaired_model_a
repaired_model_b}
}
\author{
Ridho Rahmadi \email{r.rahmadi@cs.ru.nl}
}

