% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{acidata}
\alias{acidata}
\title{U.S. Actuaries Climate Index, GDP growth rate, CPI, and interest rate data}
\format{
A numeric matrix of class \code{'ts'} with 735 rows and 4 columns with one time series in each column:
\describe{
  \item{First column (GDP):}{The cyclical component of the log of real GDP, \url{https://fred.stlouisfed.org/series/GDPC1}.}
  \item{Second column (GDPDEF):}{The log-difference of GDP implicit price deflator, \url{https://fred.stlouisfed.org/series/GDPDEF}.}
  \item{Third column (RATE):}{The Federal funds rate from 1954Q3 to 2008Q2 and after that the Wu and Xia (2016) shadow rate,
   \url{https://fred.stlouisfed.org/series/FEDFUNDS}, \url{https://www.atlantafed.org/cqer/research/wu-xia-shadow-federal-funds-rate}.}
}
}
\source{
The Federal Reserve Bank of St. Louis database and the Federal Reserve Bank of Atlanta's website
}
\usage{
acidata
}
\description{
A monthly  U.S. data covering the period from 1961I to 2022III (735 observations) and consisting four variables.
First, The Actuaries Climate Index (ACI), which is a measure of the frequency of severe weather and the extend changes in sea levels.
Second, the monthly GDP growth rate constructed by the Federal Reserve Bank of Chicago from a collapsed dynamic factor analysis of
a panel of 500 monthly measures of real economic activity and quarterly real GDP growth. Third, the monthly growth rate of the
consumer price index (CPI). Third, an interest rate variable, which is the effective federal funds rate that is replaced by the
the Wu and Xia (2016) shadow rate during zero-lower-bound periods. The Wu and Xia (2016) shadow rate is not bounded by the zero
lower bound and also quantifies unconventional monetary policy measures, while it closely follows the federal funds rate when the
zero lower bound does not bind.
}
\references{
\itemize{
   \item American Academy of Actuaries, Canadian Institute of Actuaries, Casualty Actuarial Society,
    and Society of Actuaries, 2023. Actuaries Climate Index. https://actuariesclimateindex.org.
  \item Federal Reserve Bank of Chicago, 2023. Monthly GDP Growth Rate Data. \url{https://www.chicagofed.org/publications/bbki/index}.
   \item Wu J. and Xia F. 2016. Measuring the macroeconomic impact of monetary policy at the zero lower bound.
     \emph{Journal of Money, Credit and Banking}, 48(2-3): 253-291.
 }
}
\keyword{datasets}
