% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prs.R
\name{prs.train.cv}
\alias{prs.train.cv}
\title{Polygenic risk score (given only allele frequencies); training with CV}
\usage{
prs.train.cv(X0, X1, K = 3, w = 1, nlambda = 100, verbose = FALSE)
}
\arguments{
\item{X0, X1}{n x p vectors of control and case genotypes, additively coded; IMPORTANT: coding must be relative to the same allele in both cases and controls}

\item{K}{number of folds for CV}

\item{w}{p x 1 weight vector}

\item{nlambda}{number of thresholds to tune over}

\item{verbose}{if TRUE, report current fold of CV}
}
\value{
\item{pi0}{minor allele frequencies in controls of kept SNPs}
\item{pi1}{minor allele frequencies in cases of kept SNPs}
\item{w}{weight vector for kept SNPs}
\item{lambda}{lambda cutoff}
\item{P}{proportion of cases}
}
\description{
Uses CV to select how many SNPs to include. SNPs are ordered by the magnitude of their estimated (ang possibly weighted) allelic log-odds ratio. The discriminant function is
\deqn{\sum_j\hat{\beta}_jI\left(\left\vert\frac{\hat{\beta}_j}{w_j}\right\vert>\lambda\right)X_j,}
where \eqn{X_j} is the additively coded genotype of SNP j.
}
\examples{
p <- 1000; ## number of snps
I <- rep(0,p); I[1:10] <- 1; ## which snps are causal
set.seed(1); pi0 <- runif(p,0.1,0.5); ## control minor allele frequencies
set.seed(1); ors <- runif(sum(I),-1,1); ## odds ratios
pi1 <- pi0;
pi1[I==1] <- expit(ors+logit(pi0[I==1]));
n0 <- 100; ## number of controls
X0 <- t(replicate(n0,rbinom(p,2,pi0))); ## controls
n1 <- 50; ## number of cases
X1 <- t(replicate(n1,rbinom(p,2,pi1))); ## cases
prs.train.cv(X0,X1,K=3,w=1,nlambda=100,verbose=TRUE);

}
