% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qts-class.R
\name{centring_qts}
\alias{centring_qts}
\title{QTS Centering and Standardization}
\usage{
centring_qts(x, standardize = FALSE, keep_summary_stats = FALSE)
}
\arguments{
\item{x}{An object of class \code{\link{qts}}.}

\item{standardize}{A boolean specifying whether to standardize the QTS in
addition to centering it. Defaults to \code{FALSE}.}

\item{keep_summary_stats}{A boolean specifying whether the mean and standard
deviation used for standardizing the data should be stored in the output
object. Defaults to \code{FALSE} in which case only the centered
\code{\link{qts}} is returned.}
}
\value{
If \code{keep_summary_stats = FALSE}, an object of class \code{\link{qts}}
in which quaternions have been centered (and possibly standardized) around
their geometric mean. If \code{keep_summary_stats = TRUE}, a list with three
components:
\itemize{
\item \code{qts}: an object of class \code{\link{qts}} in which quaternions have
been centered (and possibly standardized) around their geometric mean;
\item \code{mean}: a numeric vector with the quaternion Fréchet mean;
\item \code{sd}: a numeric value with the quaternion Fréchet standard deviation.
}
}
\description{
This function operates a centring of the QTS around the geometric mean of
its quaternions. This is effectively achieved by left-multiplying each
quaternion by the inverse of their geometric mean.
}
\examples{
centring_qts(vespa64$igp[[1]])
}
