% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_player_.R
\name{get_players}
\alias{get_players}
\title{Get PSA Squash Player Data from SquashInfo}
\usage{
get_players(top = NULL, rank = NULL, category = NULL)
}
\arguments{
\item{top}{integer indicating the number of top PSA players by rank to return.}

\item{rank}{integer indicating the rank of the PSA player(s) to return.}

\item{category}{character string indicating the competition category. Must be one of "mens", "womens", or "both".}
}
\value{
Tibble containing first name, last name, age, gender, birthplace, nationality, residence, height in cm, weight in kg, plays (handedness), racket brand, year of joining PSA, university, and club.
}
\description{
Given the rank(s) and competition category, \code{get_players()} returns profile data of ranked players in PSA World Tour competitions.
}
\note{
This function only returns players ranked in the most recent PSA rankings table for Men's and Women's singles competitions.
}
\examples{
## Return the top 5 ranked players from the Women's PSA rankings
\donttest{get_players(top = 5, category = "womens")}

## Return the 5th ranked player from both Men's and Women's PSA rankings
\donttest{get_players(rank = 5, category = "both")}

}
\references{
\url{http://www.squashinfo.com/rankings/men} \cr
    \url{http://www.squashinfo.com/rankings/women}
}
