% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grtspts.R
\name{grtspts}
\alias{grtspts}
\title{Select a Generalized Random-Tesselation Stratified (GRTS) Sample of a Finite Resource}
\usage{
grtspts(ptsframe, samplesize = 100, SiteBegin = 1, shift.grid = TRUE,
  do.sample = TRUE, startlev = NULL, maxlev = 11)
}
\arguments{
\item{ptsframe}{The sf object containing attributes: id, x, y, mdcaty, and
mdm.}

\item{samplesize}{Number of points to select in the sample.  The default is
100.}

\item{SiteBegin}{First number to start siteID numbering.  The default is 1.}

\item{shift.grid}{Option to randomly shift the hierarchical grid.  The
default is TRUE.}

\item{do.sample}{Option to select a sample, where TRUE means select a
sample and FALSE means return the entire sample frame in reverse
hierarchical order. The default is TRUE.}

\item{startlev}{Initial number of hierarchical levels to use for the GRTS
grid, which must be less than or equal to maxlev (if maxlev is specified)
and cannot be greater than 11.  The default is NULL.}

\item{maxlev}{Maximum number of hierarchical levels to use for the GRTS
grid, which cannot be greater than 11.  The default is 11.}
}
\value{
Data frame of sample points containing: siteID, id, x, y, mdcaty,
  and weight.
}
\description{
This function select a GRTS sample of a finite resource.  This function uses
hierarchical randomization to ensure that the sample will include no more
than one point per grid cell and then picks a point in selected cells.
}
\section{Other Functions Required}{

  \describe{
    \item{\code{numLevels}}{determines the number of levels for hierarchical
      randomization}
    \item{\code{constructAddr}}{constructs the hierarchical address for
      sample points}
    \item{\code{ranho}}{constructs the randomized hierarchical address for
      sample points}
    \item{\code{pickGridCells}}{selects grid cells that get a sample point}
    \item{\code{\link{pickFiniteSamplePoints}}}{pick sample point(s) from
      selected cells}
  }
}

\author{
Tom Kincaid \email{Kincaid.Tom@epa.gov}
 Tony Olsen \email{Olsen.Tony@epa.gov}\cr
}
\keyword{survey}
