% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hotspot_cluster.R
\name{plot.spotoroo}
\alias{plot.spotoroo}
\title{Plotting spatiotemporal clustering result}
\usage{
\method{plot}{spotoroo}(x, ...)
}
\arguments{
\item{x}{\code{spotoroo} object.
A result of a call to \code{\link[=hotspot_cluster]{hotspot_cluster()}}.}

\item{...}{Additional arguments pass to \code{\link[=plot_spotoroo]{plot_spotoroo()}}}
}
\value{
A \code{ggplot} object. The plot of the clustering results.
}
\description{
\code{plot.spotoroo()} is the \code{plot} method of the class \code{spotoroo}.
It is a simple wrapper of \code{\link[=plot_spotoroo]{plot_spotoroo()}}.
}
\examples{

\donttest{

  # Time consuming functions (>5 seconds)


  # Get clustering results
  result <- hotspot_cluster(hotspots,
                           lon = "lon",
                           lat = "lat",
                           obsTime = "obsTime",
                           activeTime = 24,
                           adjDist = 3000,
                           minPts = 4,
                           minTime = 3,
                           ignitionCenter = "mean",
                           timeUnit = "h",
                           timeStep = 1)



  # Different types of plots

  # Default plot
  plot(result, "def", bg = plot_vic_map())

  # Fire movement plot
  plot(result, "mov", cluster = 1:3, step = 3, bg = plot_vic_map())
}

}
