% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search.R
\name{search_spotify}
\alias{search_spotify}
\title{Search for an item}
\usage{
search_spotify(q, type = c("album", "artist", "playlist", "track"),
  market = NULL, limit = 20, offset = 0, include_external = NULL,
  authorization = get_spotify_access_token())
}
\arguments{
\item{q}{Required. \cr
Search query keywords and optional field filters and operators.}

\item{type}{A character vector of item types to search across. \cr
Valid types are \code{album}, \code{artist}, \code{playlist}, and \code{track}. \cr
Search results include hits from all the specified item types. \cr
For example: \code{q = "name:abacab"} and \code{type =c("album", "track")} returns both albums and tracks with \code{"abacab"} included in their name.}

\item{market}{Optional. \cr
An ISO 3166-1 alpha-2 country code or the string \code{"from_token"}. \cr
If a country code is specified, only artists, albums, and tracks with content that is playable in that market is returned. \cr
Note: \cr
- Playlist results are not affected by the market parameter. \cr
- If market is set to \code{"from_token"}, and a valid access token is specified in the request header, only content playable in the country associated with the user account, is returned. \cr
- Users can view the country that is associated with their account in the account settings. A user must grant access to the user-read-private scope prior to when the access token is issued.}

\item{limit}{Optional. \cr
Maximum number of results to return. \cr
Default: 20 \cr
Minimum: 1 \cr
Maximum: 50 \cr
Note: The limit is applied within each type, not on the total response. \cr
For example, if the limit value is 3 and the type is \code{c("artist", "album")}, the response contains 3 artists and 3 albums.}

\item{offset}{Optional. \cr
The index of the first result to return. \cr
Default: 0 (the first result). \cr
Maximum offset (including limit): 10,000. \cr
Use with limit to get the next page of search results.}

\item{include_external}{Optional. \cr
Possible values: audio \cr
If \code{include_external = "audio"} is specified the response will include any relevant audio content that is hosted externally. \cr
By default external content is filtered out from responses.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{https://developer.spotify.com/documentation/general/guides/authorization-guide/}{Web API authorization guide} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}
}
\description{
Get Spotify Catalog information about artists, albums, tracks or playlists that match a keyword string. For more information see the official \href{https://developer.spotify.com/documentation/web-api/reference/search/search/}{documentation}.
}
\examples{
\dontrun{
search_spotify('radiohead', 'artist')
}
}
\keyword{search}
