% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/artists.R
\name{get_artist}
\alias{get_artist}
\title{Get Spotify catalog information for a single artist identified by their unique Spotify ID.}
\usage{
get_artist(id, authorization = get_spotify_access_token())
}
\arguments{
\item{id}{The \href{https://developer.spotify.com/documentation/web-api/#spotify-uris-and-ids}{Spotify ID} for the artist.}

\item{authorization}{Required. A valid access token from the Spotify Accounts service. See the \href{Web API authorization Guide}{https://developer.spotify.com/documentation/general/guides/authorization-guide/} for more details. Defaults to \code{spotifyr::get_spotify_access_token()}}
}
\value{
Returns a data frame of results containing album data. See \url{https://developer.spotify.com/documentation/web-api/reference/albums/get-album/} for more information.
}
\description{
Get Spotify catalog information for a single artist identified by their unique Spotify ID.
}
